<?php
// token_callback.php
require_once 'includes/db_config.php';
require_once 'vendor/autoload.php';
use Yabacon\Paystack;

$paystack = new Paystack('sk_test_your_secret_key');
$trx = $paystack->transaction->verify(['reference' => $_GET['reference']]);

if ($trx->status && $trx->data->status === 'success') {
    $purchase_id = get_purchase_id_by_tx($trx->data->reference, $link); // Custom function
    $sql = "UPDATE token_purchases SET status = 'approved', approved_by = 0, approved_at = NOW() WHERE id = ?";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "i", $purchase_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);

    // Credit tokens
    $sql = "UPDATE token_balances SET balance = balance + (SELECT quantity FROM token_purchases WHERE id = ?) WHERE user_id = (SELECT user_id FROM token_purchases WHERE id = ?)";
    $stmt = mysqli_prepare($link, $sql);
    mysqli_stmt_bind_param($stmt, "ii", $purchase_id, $purchase_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);

    send_purchase_approval_email($purchase_id, $link);
    redirect("token_store.php?success=1");
} else {
    redirect("token_store.php?error=payment_failed");
}
?>