<?php
// includes/sidebar.php
require_once 'includes/db_config.php';
require_once 'includes/functions.php';

// Initialize session
initialize_session();

// Debug session data
error_log("Session Data in sidebar.php: " . json_encode([
    'is_logged_in' => is_logged_in(),
    'user_id' => $_SESSION['user_id'] ?? 'none',
    'user_role' => $_SESSION['user_role'] ?? 'none',
    'session_id' => session_id(),
    'session_vars' => $_SESSION
]));

// Check if user is logged in
if (!is_logged_in()) {
    redirect("login.php");
}

$system_logo = get_setting('system_logo', $link) ?? 'assets/images/default_logo.png';
$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$user_role = $_SESSION['user_role'] ?? '';
?>

<nav id="sidebarMenu" class="col-md-3 col-lg-2 bg-dark sidebar text-white">
    <div class="position-sticky pt-3 d-flex flex-column" style="height: 100vh;">
        <div class="d-flex flex-column align-items-center mb-4">
            <img src="<?php echo htmlspecialchars($system_logo, ENT_QUOTES, 'UTF-8'); ?>" alt="Club Logo" class="logo-img mb-3" style="width: 80px; height: 80px;">
            <span class="logo-text h4 text-center"><?php echo htmlspecialchars($system_name, ENT_QUOTES, 'UTF-8'); ?></span>
        </div>

        <ul class="nav flex-column flex-grow-1">
            <?php if (!is_logged_in()): ?>
                <!-- Non-Logged-In Section -->
                <li class="nav-item">
                    <a class="nav-link text-white" href="login.php">
                        <i class="fas fa-sign-in-alt me-2"></i>Login
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="register.php">
                        <i class="fas fa-user-plus me-2"></i>Join Our Club
                    </a>
                </li>
            <?php else: ?>
                <!-- My Profile (Common to All Roles) -->
                <li class="nav-item">
                    <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'profile.php' ? 'active' : ''; ?>" href="profile.php">
                        <i class="fas fa-user-circle me-2"></i>My Profile
                    </a>
                </li>

                <?php if ($user_role === 'member'): ?>
                    <!-- Member Section -->
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'member_dashboard.php' ? 'active' : ''; ?>" href="member_dashboard.php">
                            <i class="fas fa-home me-2"></i>Member Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'my_payments.php' ? 'active' : ''; ?>" href="my_payments.php">
                            <i class="fas fa-credit-card me-2"></i>My Payments
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'messages.php' ? 'active' : ''; ?>" href="messages.php">
                            <i class="fas fa-envelope me-2"></i>My Messages
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'announcements.php' ? 'active' : ''; ?>" href="announcements.php">
                            <i class="fas fa-bullhorn me-2"></i>Announcements
                        </a>
                    </li>
                    <?php if (user_has_permission($link, 'view_token_store')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'token_store.php' ? 'active' : ''; ?>" href="token_store.php">
                                <i class="fas fa-coins me-2"></i>Token Store
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_member_directory')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'member_directory.php' ? 'active' : ''; ?>" href="member_directory.php">
                                <i class="fas fa-users me-2"></i>Member Directory
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_payments')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'financial_summary.php' ? 'active' : ''; ?>" href="financial_summary.php">
                                <i class="fas fa-file-invoice-dollar me-2"></i>Financial Summary
                            </a>
                        </li>
                    <?php endif; ?>
                <?php elseif ($user_role === 'admin'): ?>
                    <!-- Admin Section -->
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'admin_dashboard.php' ? 'active' : ''; ?>" href="admin_dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Admin Dashboard
                        </a>
                    </li>
                    <?php if (user_has_permission($link, 'manage_members')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'member_management.php' ? 'active' : ''; ?>" href="member_management.php">
                                <i class="fas fa-users-cog me-2"></i>Club Membership
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_member_directory')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'member_directory.php' ? 'active' : ''; ?>" href="member_directory.php">
                                <i class="fas fa-users me-2"></i>Club Directory
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'manage_news')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'announcement_management.php' ? 'active' : ''; ?>" href="announcement_management.php">
                                <i class="fas fa-bullhorn me-2"></i>Announcements
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'manage_messages')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'messages_admin.php' ? 'active' : ''; ?>" href="messages_admin.php">
                                <i class="fas fa-envelope me-2"></i>Messages
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'manage_forms')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'form_builder.php' ? 'active' : ''; ?>" href="form_builder.php">
                                <i class="fas fa-file-alt me-2"></i>Form Builder
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_expenses') || user_has_permission($link, 'view_benefits') || user_has_permission($link, 'manage_payment_types')): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link text-white dropdown-toggle <?php echo in_array(basename($_SERVER['PHP_SELF']), ['manage_payment_types.php', 'modify_records.php', 'record_payments.php', 'record_expenses.php', 'record_benefits.php']) ? 'active' : ''; ?>" href="#" id="financeDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-money-check-alt me-2"></i>Manage Finance
                            </a>
                            <ul class="dropdown-menu dropdown-menu-dark" aria-labelledby="financeDropdown">
                                <?php if (user_has_permission($link, 'manage_payment_types')): ?>
                                    <li><a class="dropdown-item" href="manage_payment_types.php">Manage Types</a></li>
                                <?php endif; ?>
                                <li><a class="dropdown-item" href="modify_records.php">Modify Records</a></li>
                                <?php if (user_has_permission($link, 'view_payments')): ?>
                                    <li><a class="dropdown-item" href="record_payments.php">Record Payments</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_expenses')): ?>
                                    <li><a class="dropdown-item" href="record_expenses.php">Record Expenses</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_benefits')): ?>
                                    <li><a class="dropdown-item" href="record_benefits.php">Record Benefits</a></li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_payments')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'financial_summary.php' ? 'active' : ''; ?>" href="financial_summary.php">
                                <i class="fas fa-file-invoice-dollar me-2"></i>Financial Summary
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'manage_obligations')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'manage_obligations.php' ? 'active' : ''; ?>" href="manage_obligations.php">
                                <i class="fas fa-handshake me-2"></i>Obligations
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_expenses') || user_has_permission($link, 'view_debts') || user_has_permission($link, 'view_benefits')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'active' : ''; ?>" href="reports.php">
                                <i class="fas fa-chart-bar me-2"></i>Financial Reports
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_token_store')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'token_store.php' ? 'active' : ''; ?>" href="token_store.php">
                                <i class="fas fa-coins me-2"></i>Token Store
                            </a>
                        </li>
                    <?php endif; ?>
                <?php elseif ($user_role === 'super_admin'): ?>
                    <!-- Super Admin Section -->
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'super_admin_dashboard.php' ? 'active' : ''; ?>" href="super_admin_dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Super Admin Dashboard
                        </a>
                    </li>
                    <?php if (user_has_permission($link, 'manage_bank_settings')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'bank_settings.php' ? 'active' : ''; ?>" href="bank_settings.php">
                                <i class="fas fa-university me-2"></i>Bank Settings
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'manage_token_settings')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'token_settings.php' ? 'active' : ''; ?>" href="token_settings.php">
                                <i class="fas fa-cog me-2"></i>Token Settings
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'manage_token_purchases')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'manage_token_purchases.php' ? 'active' : ''; ?>" href="manage_token_purchases.php">
                                <i class="fas fa-shopping-cart me-2"></i>Manage Token Purchases
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_settings')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'admin_settings.php' ? 'active' : ''; ?>" href="admin_settings.php">
                                <i class="fas fa-cogs me-2"></i>Admin Settings
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'role_permissions.php' ? 'active' : ''; ?>" href="role_permissions.php">
                                <i class="fas fa-user-shield me-2"></i>Role Permissions
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'smtp_setup.php' ? 'active' : ''; ?>" href="smtp_setup.php">
                                <i class="fas fa-envelope-open-text me-2"></i>SMTP Setup
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_token_store')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'token_store.php' ? 'active' : ''; ?>" href="token_store.php">
                                <i class="fas fa-coins me-2"></i>Token Store
                            </a>
                        </li>
                    <?php endif; ?>
                <?php elseif ($user_role === 'accountant'): ?>
                    <!-- Accountant Section -->
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'accountant_dashboard.php' ? 'active' : ''; ?>" href="accountant_dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Accountant Dashboard
                        </a>
                        </li>
                    <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_expenses') || user_has_permission($link, 'view_benefits') || user_has_permission($link, 'manage_payment_types')): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link text-white dropdown-toggle <?php echo in_array(basename($_SERVER['PHP_SELF']), ['manage_payment_types.php', 'modify_records.php', 'record_payments.php', 'record_expenses.php', 'record_benefits.php']) ? 'active' : ''; ?>" href="#" id="financeDropdownAcc" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-money-check-alt me-2"></i>Manage Finance
                            </a>
                            <ul class="dropdown-menu dropdown-menu-dark" aria-labelledby="financeDropdownAcc">
                                <?php if (user_has_permission($link, 'manage_payment_types')): ?>
                                    <li><a class="dropdown-item" href="manage_payment_types.php">Manage Types</a></li>
                                <?php endif; ?>
                                <li><a class="dropdown-item" href="modify_records.php">Modify Records</a></li>
                                <?php if (user_has_permission($link, 'view_payments')): ?>
                                    <li><a class="dropdown-item" href="record_payments.php">Record Payments</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_expenses')): ?>
                                    <li><a class="dropdown-item" href="record_expenses.php">Record Expenses</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_benefits')): ?>
                                    <li><a class="dropdown-item" href="record_benefits.php">Record Benefits</a></li>
                                <?php endif; ?>
                            </ul>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_member_directory')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'member_directory.php' ? 'active' : ''; ?>" href="member_directory.php">
                                <i class="fas fa-users me-2"></i>Member Directory
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_payments')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'financial_summary.php' ? 'active' : ''; ?>" href="financial_summary.php">
                                <i class="fas fa-file-invoice-dollar me-2"></i>Financial Summary
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php if (user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_expenses') || user_has_permission($link, 'view_debts') || user_has_permission($link, 'view_benefits')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo basename($_SERVER['PHP_SELF']) == 'reports.php' ? 'active' : ''; ?>" href="reports.php">
                                <i class="fas fa-chart-bar me-2"></i>Financial Reports
                            </a>
                        </li>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
        </ul>

        <!-- Logout Button -->
        <div class="mt-auto logout-container">
            <a href="logout.php" class="logout-btn btn text-white w-100">Logout</a>
        </div>
    </div>
</nav>

<style>
.sidebar {
    min-height: 100vh;
}
.nav {
    padding-bottom: 50px; /* Excess spacing after last menu item */
}
.nav-item {
    margin-bottom: 10px; /* Spacing between menu items */
}
.sidebar-heading {
    font-size: 0.875rem;
}
.logo-img {
    width: 80px;
    height: 80px;
}
.logo-text {
    font-size: 1.25rem;
}
.logout-btn {
    background-color: #dc3545;
    border-radius: 10px;
    padding: 15px 25px;
    margin: 15px 20px 25px 20px;
    font-size: 1.1rem;
    transition: background-color 0.3s;
}
.logout-btn:hover {
    background-color: #c82333;
}
.logout-container {
    padding-bottom: 20px; /* Additional spacing after logout button */
}
.dropdown-menu-dark {
    background-color: #343a40;
    border: none;
}
.dropdown-item {
    color: #ffffff;
}
.dropdown-item:hover {
    background-color: #495057;
}
</style>