<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
}

$message = '';
$edit_id = null;
$edit_form_name = '';

// Handle form submission (add/update)
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $form_name = sanitize_input($_POST['form_name']);
    $form_data = isset($_POST['form_data']) ? $_POST['form_data'] : null;
    $form_id = isset($_POST['form_id']) && !empty($_POST['form_id']) ? intval($_POST['form_id']) : null;

    if ($form_id) {
        $sql = "UPDATE forms SET form_name = ?, form_data = ?, created_at = NOW() WHERE id = ?";
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "ssi", $form_name, $form_data, $form_id);
            if (mysqli_stmt_execute($stmt)) {
                $message = "Form updated successfully!";
            } else {
                $message = "Error updating form: " . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        }
    } else {
        $sql = "INSERT INTO forms (form_name, form_data, created_at) VALUES (?, ?, NOW())";
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "ss", $form_name, $form_data);
            if (mysqli_stmt_execute($stmt)) {
                $message = "Form created successfully!";
            } else {
                $message = "Error creating form: " . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        }
    }
}

// Handle delete action
if (isset($_GET['delete_id'])) {
    $delete_id = intval($_GET['delete_id']);
    $sql = "DELETE FROM forms WHERE id = ?";
    if ($stmt = mysqli_prepare($link, $sql)) {
        mysqli_stmt_bind_param($stmt, "i", $delete_id);
        if (mysqli_stmt_execute($stmt)) {
            $message = "Form deleted successfully!";
        } else {
            $message = "Error deleting form.";
        }
        mysqli_stmt_close($stmt);
    }
}

// Handle edit action and load existing form data
$existing_form_data = '{"fields":[]}';
if (isset($_GET['edit_id'])) {
    $edit_id = intval($_GET['edit_id']);
    $sql = "SELECT form_name, form_data FROM forms WHERE id = ?";
    if ($stmt = mysqli_prepare($link, $sql)) {
        mysqli_stmt_bind_param($stmt, "i", $edit_id);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_bind_result($stmt, $edit_form_name, $existing_form_data_db);
        mysqli_stmt_fetch($stmt);
        mysqli_stmt_close($stmt);
        if (!empty($existing_form_data_db)) {
            $existing_form_data = $existing_form_data_db;
        }
    }
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Form Builder</h2>
            
            <?php if ($message): ?>
                <div class="message <?php echo strpos($message, 'Error') !== false ? 'error-message' : 'success-message'; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <div class="form-builder-container">
                <div class="form-palette">
                    <h3>Form Fields</h3>
                    <div class="draggable-field" data-type="text">Text Input</div>
                    <div class="draggable-field" data-type="email">Email Input</div>
                    <div class="draggable-field" data-type="password">Password Input</div>
                    <div class="draggable-field" data-type="username">Username Input</div>
                    <div class="draggable-field" data-type="date">Date Input</div>
                    <div class="draggable-field" data-type="textarea">Text Area</div>
                    <div class="draggable-field" data-type="checkbox">Checkbox</div>
                    <div class="draggable-field" data-type="radio">Radio Buttons</div>
                    <div class="draggable-field" data-type="select">Dropdown Select</div>
                    <div class="draggable-field" data-type="file">File Upload</div>
                    <button id="add-step-btn" class="btn btn-secondary">Add Step</button>
                </div>
                <div class="form-editor">
                    <h3>Form Editor</h3>
                    <form id="form-builder-form" action="form_builder.php" method="post">
                        <input type="hidden" name="form_id" value="<?php echo htmlspecialchars($edit_id ?? ''); ?>">
                        <div class="form-group">
                            <label for="form-name">Form Name</label>
                            <input type="text" id="form-name" name="form_name" class="form-control" value="<?php echo htmlspecialchars($edit_form_name ?? ''); ?>" required>
                        </div>
                        
                        <div id="form-canvas">
                        </div>
                        
                        <input type="hidden" name="form_data" id="form-data-input">
                        <button type="submit" class="btn btn-primary">Save Form</button>
                    </form>
                </div>
            </div>

            <div id="field-edit-modal" class="modal" style="display: none;">
                <div class="modal-content">
                    <span class="close-button">&times;</span>
                    <h4>Edit Field</h4>
                    <div class="form-group">
                        <label for="field-label-edit">Field Label</label>
                        <input type="text" id="field-label-edit" class="form-control">
                    </div>
                    <div class="form-group">
                        <label for="field-name-edit">Field Name</label>
                        <input type="text" id="field-name-edit" class="form-control" readonly>
                    </div>
                    <div class="form-group form-check">
                        <input type="checkbox" id="field-required-edit" class="form-check-input">
                        <label class="form-check-label" for="field-required-edit">Required Field</label>
                    </div>
                    <div class="form-group" id="field-options-group" style="display: none;">
                        <label>Options (One per line)</label>
                        <textarea id="field-options-edit" class="form-control"></textarea>
                    </div>
                    <div class="form-group" id="conditional-logic-group">
                        <h5>Conditional Logic (Show/Hide)</h5>
                        <div id="conditional-rules"></div>
                        <button type="button" class="btn btn-sm btn-info" id="add-conditional-rule">Add Rule</button>
                    </div>
                    <button id="save-field-edit" class="btn btn-primary">Save Changes</button>
                </div>
            </div>
            
            <hr>
            
            <div class="list-section">
                <h3>Existing Forms</h3>
                <table class="form-list">
                    <thead>
                        <tr>
                            <th>Form Name</th>
                            <th>Created At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        $sql = "SELECT id, form_name, created_at FROM forms ORDER BY created_at DESC";
                        $result = mysqli_query($link, $sql);
                        if (mysqli_num_rows($result) > 0) {
                            while ($row = mysqli_fetch_assoc($result)) {
                                echo "<tr>";
                                echo "<td>" . htmlspecialchars($row['form_name']) . "</td>";
                                echo "<td>" . date("F j, Y", strtotime($row['created_at'])) . "</td>";
                                echo "<td>";
                                echo "<a href='form_builder.php?edit_id=" . $row['id'] . "' class='btn btn-secondary btn-sm'>Edit</a> ";
                                echo "<a href='form_builder.php?delete_id=" . $row['id'] . "' class='btn btn-danger btn-sm' onclick='return confirm(\"Are you sure?\");'>Delete</a>";
                                echo "</td>";
                                echo "</tr>";
                            }
                        } else {
                            echo "<tr><td colspan='3'>No forms created yet.</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>
<script src="assets/js/jquery-3.7.1.min.js"></script>
<script src="assets/js/jquery-ui-1.14.1/jquery-ui.min.js"></script>
<script>
    // Pass existing form data from PHP to a JavaScript variable for editing
    var existingFormData = <?php echo $existing_form_data; ?>;
</script>
<script src="assets/js/form_builder.js"></script>