$(function() {
    let currentStep = 0;
    const steps = $(".form-step");
    const totalSteps = steps.length;
    const nextBtn = $(".next-step");
    const prevBtn = $(".prev-step");
    const registerBtn = $("button[name='register']");

    // Hide all steps initially and show the first one
    steps.hide();
    steps.eq(0).show();

    // Function to update button visibility
    function updateButtons() {
        if (currentStep === 0) {
            prevBtn.hide();
        } else {
            prevBtn.show();
        }

        if (currentStep === totalSteps - 1) {
            nextBtn.hide();
            registerBtn.show();
        } else {
            nextBtn.show();
            registerBtn.hide();
        }
    }
    updateButtons();

    // Function to validate the current step's fields
    function validateStep(stepIndex) {
        let isValid = true;
        $(`.form-step[data-step="${stepIndex}"]`).find('input[required], textarea[required], select[required]').each(function() {
            if ($(this).val().trim() === '') {
                isValid = false;
                $(this).addClass('is-invalid');
                if ($(this).next('.invalid-feedback').length === 0) {
                    $(this).after('<div class="invalid-feedback">This field is required.</div>');
                }
            } else {
                $(this).removeClass('is-invalid');
                $(this).next('.invalid-feedback').remove();
            }
        });
        return isValid;
    }

    // Handle next step
    nextBtn.on("click", function() {
        if (validateStep(currentStep)) {
            steps.eq(currentStep).hide();
            currentStep++;
            steps.eq(currentStep).show();
            updateButtons();
        }
    });

    // Handle previous step
    prevBtn.on("click", function() {
        if (currentStep > 0) {
            steps.eq(currentStep).hide();
            currentStep--;
            steps.eq(currentStep).show();
            updateButtons();
        }
    });

    // Handle form submission
    $("form").on("submit", function(event) {
        if (!validateStep(currentStep)) {
            event.preventDefault();
        }
    });
});