<?php
// This API fetches a summary of payments grouped by payment type.
require_once '../includes/db_config.php';

// Set the content type to JSON
header('Content-Type: application/json');

try {
    // Fetch all payment data with user details in one query
    // Changed the SELECT statement to use `u.full_name`
    $sql = "SELECT p.payment_type, p.amount, u.id AS member_id, u.full_name FROM payments p JOIN users u ON p.user_id = u.id ORDER BY p.payment_type, u.full_name";

    $result = $link->query($sql);

    $summary_by_type = [];
    $total_paid = 0;

    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $type = $row['payment_type'];
            $amount = floatval($row['amount']);

            if (!isset($summary_by_type[$type])) {
                $summary_by_type[$type] = [
                    'total_paid' => 0,
                    'members' => []
                ];
            }

            $summary_by_type[$type]['total_paid'] += $amount;
            $summary_by_type[$type]['members'][] = [
                'member_id' => $row['member_id'],
                // Using the full_name column for a cleaner output
                'full_name' => $row['full_name'],
                'amount' => number_format($amount, 2)
            ];
            
            $total_paid += $amount;
        }
    }
    
    // Format the totals
    foreach ($summary_by_type as $type => $summary) {
        $summary_by_type[$type]['total_paid'] = number_format($summary['total_paid'], 2);
    }

    $response = [
        'success' => true,
        'summary_by_type' => $summary_by_type,
        'total_paid' => number_format($total_paid, 2),
        'message' => empty($summary_by_type) ? 'No payment summary found.' : 'Payment summary retrieved successfully.'
    ];

} catch (Exception $e) {
    $response = [
        'success' => false,
        'message' => 'Error fetching payment summary: ' . $e->getMessage()
    ];
}

echo json_encode($response);
?>
