<?php
require_once '../includes/functions.php';
require_once '../includes/db_config.php';
session_start();

// Check if user is logged in and is admin
if (!is_logged_in() || !is_admin()) {
    http_response_code(403);
    exit('Access denied');
}

// Check database connection
if (!$link) {
    http_response_code(500);
    exit("ERROR: Could not connect. " . mysqli_connect_error());
}

// Filter settings
$record_type = isset($_GET['record_type']) && in_array($_GET['record_type'], ['all', 'benefits']) ? $_GET['record_type'] : 'all';
$time_period = isset($_GET['time_period']) && in_array($_GET['time_period'], ['date', 'week', 'month', 'year', 'all']) ? $_GET['time_period'] : 'all';
$filter_date = isset($_GET['filter_date']) ? $_GET['filter_date'] : date('Y-m-d');

// Build time filter
$time_filter = '';
$bind_params = [];
$bind_types = '';
if ($time_period !== 'all') {
    switch ($time_period) {
        case 'date':
            $time_filter = " AND DATE(b.created_at) = ?";
            $filter_date_param = $filter_date;
            $bind_params[] = &$filter_date_param;
            $bind_types .= 's';
            break;
        case 'week':
            $time_filter = " AND b.created_at >= DATE_SUB(CURDATE(), INTERVAL 1 WEEK)";
            break;
        case 'month':
            $time_filter = " AND b.created_at >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
            break;
        case 'year':
            $time_filter = " AND b.created_at >= DATE_SUB(CURDATE(), INTERVAL 1 YEAR)";
            break;
    }
}

// Fetch benefits data
$sql = "SELECT 
            b.id,
            u.member_id,
            IFNULL(u.full_name, 'Unknown') AS full_name,
            bt.type_name AS benefit_type,
            b.amount,
            b.created_at
        FROM member_benefits b
        JOIN users u ON b.member_id = u.id
        JOIN benefit_types bt ON b.benefit_type_id = bt.id
        WHERE 1=1" . ($record_type == 'all' || $record_type == 'benefits' ? $time_filter : ' AND FALSE') . "
        ORDER BY b.created_at DESC";
$stmt = mysqli_prepare($link, $sql);
if ($time_period == 'date' && !empty($bind_params)) {
    mysqli_stmt_bind_param($stmt, $bind_types, ...$bind_params);
}
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);
$benefits = [];
while ($row = mysqli_fetch_assoc($result)) {
    $benefits[] = $row;
}
mysqli_stmt_close($stmt);

// Set headers for CSV download
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="benefits_export_' . date('Ymd_His') . '.csv"');

// Create CSV file
$output = fopen('php://output', 'w');
fputcsv($output, ['Member ID', 'Member Name', 'Benefit Type', 'Amount', 'Date']);

foreach ($benefits as $record) {
    fputcsv($output, [
        $record['member_id'] ?? 'N/A',
        $record['full_name'],
        $record['benefit_type'] ?? 'N/A',
        number_format($record['amount'] ?? 0, 2),
        date('Y-m-d', strtotime($record['created_at'] ?? 'now'))
    ]);
}

fclose($output);
mysqli_close($link);
exit;
?>