-- Create the users table
CREATE TABLE users (
    id INT NOT NULL AUTO_INCREMENT,
    full_name VARCHAR(255) NOT NULL,
    email VARCHAR(255) NOT NULL,
    password VARCHAR(255) NOT NULL,
    role ENUM('member', 'admin') NOT NULL DEFAULT 'member',
    membership_status ENUM('pending', 'active') NOT NULL DEFAULT 'pending',
    created_at DATETIME NOT NULL,
    PRIMARY KEY (id),
    UNIQUE KEY (email)
);

-- Add the profile_picture column to the users table
ALTER TABLE users ADD COLUMN profile_picture VARCHAR(255) DEFAULT 'assets/images/default_avatar.png';

-- Add the bio column to the users table
ALTER TABLE users ADD COLUMN bio TEXT;

-- Create the password_resets table
CREATE TABLE password_resets (
    id INT NOT NULL AUTO_INCREMENT,
    email VARCHAR(255) NOT NULL,
    token VARCHAR(255) NOT NULL,
    expires_at DATETIME NOT NULL,
    PRIMARY KEY (id)
);

-- Create the smtp_settings table
CREATE TABLE smtp_settings (
    id INT NOT NULL AUTO_INCREMENT,
    host VARCHAR(255) NOT NULL,
    port INT NOT NULL,
    username VARCHAR(255) NOT NULL,
    password VARCHAR(255) NOT NULL,
    from_email VARCHAR(255) NOT NULL,
    encryption VARCHAR(50),
    PRIMARY KEY (id)
);

-- Create the announcements table
CREATE TABLE announcements (
    id INT NOT NULL AUTO_INCREMENT,
    title VARCHAR(255) NOT NULL,
    content TEXT NOT NULL,
    created_by INT NOT NULL,
    created_at DATETIME NOT NULL,
    PRIMARY KEY (id)
);

-- Create the messages table
CREATE TABLE messages (
    id INT NOT NULL AUTO_INCREMENT,
    sender_id INT NOT NULL,
    recipient_id INT NOT NULL,
    message_content TEXT NOT NULL,
    timestamp DATETIME NOT NULL,
    is_read BOOLEAN DEFAULT FALSE,
    PRIMARY KEY (id)
);

-- Create the payments table
CREATE TABLE payments (
    id INT NOT NULL AUTO_INCREMENT,
    user_id INT NOT NULL,
    payment_type VARCHAR(50) NOT NULL,
    amount DECIMAL(10, 2) NOT NULL,
    description TEXT,
    status VARCHAR(50) NOT NULL,
    created_at DATETIME NOT NULL,
    PRIMARY KEY (id)
);