<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

if (!is_logged_in() || !is_admin()) {
    echo json_encode(['error'=>'Unauthorized']);
    exit;
}

$id = intval($_POST['id'] ?? 0);
$status = strtolower(trim($_POST['status'] ?? ''));

if (!in_array($status, ['approved','rejected'])) {
    echo json_encode(['error'=>'Invalid status']);
    exit;
}

$sql = "UPDATE users SET membership_status=? WHERE id=?";
$stmt = mysqli_prepare($link, $sql);
mysqli_stmt_bind_param($stmt, "si", $status, $id);

if (mysqli_stmt_execute($stmt)) {
    echo json_encode(['message'=>"Member has been $status successfully"]);
} else {
    echo json_encode(['error'=>'Failed to update member status']);
}
