<?php
/* --------------------------------------------------------------
   templates/fund_requests_template.php
   - Displays the filterable report for fund requests.
  -------------------------------------------------------------- */
require_once 'includes/header.php';
?>
<script>
document.title = 'Fund Requests Report - <?php echo htmlspecialchars($system_name ?? 'Club Portal'); ?>';
</script>
<!-- jsPDF and autoTable for PDF export -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.25/jspdf.plugin.autotable.min.js"></script>

<!-- 1. Include the Sidebar -->
<?php require_once 'includes/sidebar.php'; ?>

<!-- 2. START THE MAIN CONTENT AREA -->
<main class="main-content">
    
    <!-- 3. WRAP all page content in a "container-fluid" -->
    <div class="container-fluid">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
            <h1 class="h2">Fund Requests Report</h1>
        </div>

        <?php if (!empty($error_message)): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error_message); ?></div>
        <?php endif; ?>

        <!-- Filter Section -->
        <div class="card shadow-sm mb-4 filter-section no-print">
            <div class="card-body">
                <form id="filterForm" method="GET" action="fund_requests_report.php" class="row g-3 align-items-end">
                    <div class="col-md-3">
                        <label for="from_date" class="form-label fw-bold">From Date</label>
                        <input type="date" id="from_date" name="from_date" value="<?php echo htmlspecialchars($filter_from_date); ?>" class="form-control">
                    </div>
                    <div class="col-md-3">
                        <label for="to_date" class="form-label fw-bold">To Date</label>
                        <input type="date" id="to_date" name="to_date" value="<?php echo htmlspecialchars($filter_to_date); ?>" class="form-control">
                    </div>
                    <div class="col-md-2">
                        <label for="status" class="form-label fw-bold">Status</label>
                        <select id="status" name="status" class="form-select">
                            <option value="all" <?php echo $filter_status === 'all' ? 'selected' : ''; ?>>All Statuses</option>
                            <option value="pending" <?php echo $filter_status === 'pending' ? 'selected' : ''; ?>>Pending</option>
                            <option value="approved" <?php echo $filter_status === 'approved' ? 'selected' : ''; ?>>Approved</option>
                            <option value="rejected" <?php echo $filter_status === 'rejected' ? 'selected' : ''; ?>>Rejected</option>
                            <option value="spent" <?php echo $filter_status === 'spent' ? 'selected' : ''; ?>>Spent</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="type_id" class="form-label fw-bold">Request Type</label>
                        <select id="type_id" name="type_id" class="form-select">
                            <option value="0">All Types</option>
                            <?php foreach ($request_types as $type): ?>
                                <option value="<?php echo $type['id']; ?>" <?php echo $filter_type_id === $type['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($type['type_name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-2 d-flex gap-2">
                        <button type="submit" class="btn btn-primary flex-grow-1"><i class="fas fa-check me-1"></i>Apply</button>
                        <a href="fund_requests_report.php" class="btn btn-outline-secondary"><i class="fas fa-undo"></i></a>
                    </div>
                </form>
            </div>
        </div>

        <!-- Report Table -->
        <div class="card shadow-sm mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Report Results</h5>
                <button id="exportPdfBtn" class="btn btn-danger btn-sm no-print">
                    <i class="fas fa-file-pdf me-1"></i> Export to PDF
                </button>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover table-sm" id="requestsTable">
                        <thead class="table-light">
                            <tr>
                                <th>ID</th>
                                <th>Requester</th>
                                <th>Type</th>
                                <th class="text-end">Amount</th>
                                <th>Status</th>
                                <th>Purpose / Note</th>
                                <th>Admin Note</th>
                                <th>Date Requested</th>
                                <th>Date Actioned</th>
                                <th>Actioned By</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($requests)): ?>
                                <tr>
                                    <td colspan="10" class="text-center text-muted fst-italic">No requests found matching your criteria.</td>
                                </tr>
                            <?php endif; ?>
                            <?php foreach ($requests as $req): ?>
                                <tr>
                                    <td><?php echo $req['id']; ?></td>
                                    <td><?php echo htmlspecialchars($req['requester_name'] ?? 'N/A'); ?></td>
                                    <td><?php echo htmlspecialchars($req['request_type_name'] ?? 'N/A'); ?></td>
                                    <td class="text-end fw-bold"><?php echo $currency_symbol . number_format($req['amount'], 2); ?></td>
                                    <td><span class="<?php echo get_status_badge($req['status']); ?>"><?php echo ucfirst(htmlspecialchars($req['status'])); ?></span></td>
                                    <td style="max-width: 200px; white-space: pre-wrap; word-break: break-word;"><?php echo htmlspecialchars($req['purpose']); ?></td>
                                    <td style="max-width: 200px; white-space: pre-wrap; word-break: break-word;" class="text-danger"><?php echo htmlspecialchars($req['admin_note'] ?? 'N/A'); ?></td>
                                    <td><?php echo date('Y-m-d H:i', strtotime($req['created_at'])); ?></td>
                                    <td><?php echo $req['approval_date'] ? date('Y-m-d H:i', strtotime($req['approval_date'])) : 'N/A'; ?></td>
                                    <td><?php echo htmlspecialchars($req['approver_name'] ?? 'N/A'); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

    </div> <!-- END .container-fluid -->
</main> <!-- END .main-content -->

<script>
document.addEventListener('DOMContentLoaded', function () {
    const { jsPDF } = window.jspdf;

    document.getElementById('exportPdfBtn').addEventListener('click', function () {
        const doc = new jsPDF('landscape');
        const reportTitle = 'Fund Requests Report';
        const filterText = 'Filters: <?php echo "From $filter_from_date to $filter_to_date, Status: $filter_status"; ?>';
        const orgName = '<?php echo htmlspecialchars($system_name, ENT_QUOTES, 'UTF-8'); ?>';

        // Add Title
        doc.setFontSize(16);
        doc.text(reportTitle, 14, 15);
        doc.setFontSize(10);
        doc.text(orgName, 14, 21);
        doc.setFontSize(8);
        doc.text(filterText, 14, 26);
        doc.text("Generated on: " + new Date().toLocaleString(), doc.internal.pageSize.getWidth() - 14, 15, { align: 'right' });


        doc.autoTable({
            html: '#requestsTable',
            startY: 30,
            theme: 'striped',
            headStyles: {
                fillColor: [41, 128, 185], // A nice blue
                textColor: 255,
                fontStyle: 'bold'
            },
            columnStyles: {
                3: { halign: 'right' }, // Amount
                5: { cellWidth: 50 }, // Purpose
                6: { cellWidth: 50 }  // Admin Note
            },
            didDrawPage: function (data) {
                // Footer
                let footerStr = "Page " + doc.internal.getNumberOfPages();
                doc.setFontSize(8);
                doc.text(footerStr, data.settings.margin.left, doc.internal.pageSize.getHeight() - 10);
            }
        });

        doc.save('Fund_Requests_Report_<?php echo date("Y-m-d"); ?>.pdf');
    });
});
</script>

<?php require_once 'includes/footer.php'; ?>