<?php
// includes/sidebar.php
require_once 'includes/db_config.php';
require_once 'includes/functions.php'; // Ensure functions.php is included
// Initialize session
initialize_session();
// Debug session data
error_log("Session Data in sidebar.php: " . json_encode([
    'is_logged_in' => is_logged_in(),
    'user_id' => $_SESSION['user_id'] ?? 'none',
    'user_role' => $_SESSION['user_role'] ?? 'none',
    'session_id' => session_id(),
    'session_vars' => $_SESSION
]));
// Check if user is logged in
if (!is_logged_in()) {
    redirect("login.php");
}
$system_logo = get_setting('system_logo', $link) ?? 'assets/images/default_logo.png';
$system_name = get_setting('system_name', $link) ?? 'Club Portal';
$user_role = $_SESSION['user_role'] ?? '';
$current_page = basename($_SERVER['PHP_SELF']);
// Helper function to check if any of the submenu items are active
function is_parent_active($current_page, $pages_array) {
    return in_array($current_page, $pages_array);
}
// --- Page Group Definitions for Active State Logic ---
// Member Pages
$member_pages = [
    'member_dashboard.php',
    'my_payments.php',
    'member_request_fund.php',
    'messages.php',
    'announcements.php',
    'member_directory.php',
    'financial_summary.php'
];
// Admin/Accountant Pages
$finance_pages = [ // From your new template
    'manage_payment_types.php',
    'modify_records.php',
    'record_payments.php',
    'record_expenses.php',
    'record_benefits.php',
    'transfer_funds.php',
    'record_donations.php'
];
$admin_content_pages = [ // New group
    'member_management.php',
    'member_directory.php',
    'announcement_management.php',
    'messages_admin.php',
    'admin_config_finance.php',
    'role_permissions.php'
];
$financial_reports_pages = [ // New group
    'financial_summary.php',
    'reports.php'
];

// NEW: Admin-specific Settings Pages (Non-Super Admin)
$admin_settings_pages = [
    'admin_config_finance.php',
    'role_permissions.php'
];

// Super Admin Pages
$sa_settings_pages = [ // From your new template
    'bank_settings.php',
    'token_settings.php',
    'admin_settings.php',
    'role_permissions.php',
    'smtp_setup.php',
    'admin_config_finance.php'
];
$sa_token_pages = [ // New group
    'manage_token_purchases.php',
    'token_store.php'
];
?>
<!-- 
    FIX: REMOVED conflicting classes: "col-md-3 col-lg-2"
    The layout is now controlled by the CSS in header.php using the "sidebar" class
-->
<nav id="sidebarMenu" class="sidebar text-white">
    <div class="position-sticky pt-4 d-flex flex-column" style="height: 100%;">
        <div class="d-flex flex-column align-items-center mb-4">
            <img src="<?php echo htmlspecialchars($system_logo, ENT_QUOTES, 'UTF-8'); ?>" alt="Club Logo" class="logo-img mb-3" style="width: 80px; height: 80px;">
            <span class="logo-text h4 text-center"><?php echo htmlspecialchars($system_name, ENT_QUOTES, 'UTF-8'); ?></span>
        </div>
        <ul class="nav flex-column flex-grow-1">
            <?php if (!is_logged_in()): ?>
                <li class="nav-item">
                    <a class="nav-link text-white" href="login.php">
                        <i class="fas fa-sign-in-alt me-2"></i>Login
                    </a>
                </li>
                <li class="nav-item">
                    <a class="nav-link text-white" href="register.php">
                        <i class="fas fa-user-plus me-2"></i>Join Our Club
                    </a>
                </li>
            <?php else: ?>
                <li class="nav-item">
                    <a class="nav-link text-white <?php echo $current_page == 'profile.php' ? 'active' : ''; ?>" href="profile.php">
                        <i class="fas fa-user-circle me-2"></i>My Profile
                    </a>
                </li>
                <?php if ($user_role === 'member'): ?>
                    <?php
                    $is_member_open = is_parent_active($current_page, $member_pages) ? 'true' : 'false';
                    $is_member_show = is_parent_active($current_page, $member_pages) ? 'show' : '';
                    ?>
                    <li class="nav-item">
                        <a class="nav-link text-white collapse-toggle <?php echo $is_member_open == 'true' ? 'active' : ''; ?>"
                            href="#memberCollapse" data-bs-toggle="collapse" aria-expanded="<?php echo $is_member_open; ?>">
                            <i class="fas fa-user me-2"></i>Member Area <i class="fas fa-chevron-down ms-auto rotate"></i>
                        </a>
                        <div class="collapse submenu-collapse <?php echo $is_member_show; ?>" id="memberCollapse">
                            <ul class="nav flex-column sub-menu">
                                <li class="nav-item">
                                    <a class="nav-link text-white <?php echo $current_page == 'member_dashboard.php' ? 'active' : ''; ?>" href="member_dashboard.php">
                                        <i class="fas fa-home me-2"></i>Dashboard
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-white <?php echo $current_page == 'my_payments.php' ? 'active' : ''; ?>" href="my_payments.php">
                                        <i class="fas fa-credit-card me-2"></i>My Payments
                                    </a>
                                </li>
                                <?php if (user_has_permission($link, 'request_funds')): ?>
                                <li class="nav-item">
                                    <a class="nav-link text-white <?php echo $current_page == 'member_request_fund.php' ? 'active' : ''; ?>" href="member_request_fund.php">
                                        <i class="fas fa-hand-holding-usd me-2"></i>Request Funds
                                    </a>
                                </li>
                                <?php endif; ?>
                                <li class="nav-item">
                                    <a class="nav-link text-white <?php echo $current_page == 'messages.php' ? 'active' : ''; ?>" href="messages.php">
                                        <i class="fas fa-envelope me-2"></i>My Messages
                                    </a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link text-white <?php echo $current_page == 'announcements.php' ? 'active' : ''; ?>" href="announcements.php">
                                        <i class="fas fa-bullhorn me-2"></i>Announcements
                                    </a>
                                </li>
                                <?php if (user_has_permission($link, 'view_member_directory')): ?>
                                <li class="nav-item">
                                    <a class="nav-link text-white <?php echo $current_page == 'member_directory.php' ? 'active' : ''; ?>" href="member_directory.php">
                                        <i class="fas fa-users me-2"></i>Member Directory
                                    </a>
                                </li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_payments')): ?>
                                <li class="nav-item">
                                    <a class="nav-link text-white <?php echo $current_page == 'financial_summary.php' ? 'active' : ''; ?>" href="financial_summary.php">
                                        <i class="fas fa-file-invoice-dollar me-2"></i>Financial Summary
                                    </a>
                                </li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                    <?php if (user_has_permission($link, 'view_token_store')): ?>
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo $current_page == 'token_store.php' ? 'active' : ''; ?>" href="token_store.php">
                            <i class="fas fa-coins me-2"></i>Token Store
                        </a>
                    </li>
                    <?php endif; ?>
                <?php elseif ($user_role === 'admin' || $user_role === 'accountant'): ?>
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo $current_page == $user_role . '_dashboard.php' ? 'active' : ''; ?>" href="<?php echo $user_role; ?>_dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i><?php echo ucfirst($user_role); ?> Dashboard
                        </a>
                    </li>
                    
                    <?php
                    $show_finance_management = ($user_role === 'accountant' || $user_role === 'admin') || user_has_permission($link, 'manage_payment_types') ||
                                                 user_has_permission($link, 'modify_finance_records') ||
                                                 user_has_permission($link, 'record_payments') ||
                                                 user_has_permission($link, 'record_expenses') ||
                                                 user_has_permission($link, 'record_benefits') ||
                                                 user_has_permission($link, 'transfer_funds') ||
                                                 user_has_permission($link, 'record_donations');
                    
                    $collapse_id = 'financeCollapse' . ($user_role === 'accountant' ? 'Acc' : 'Adm');
                    $is_parent_open = is_parent_active($current_page, $finance_pages) ? 'true' : 'false';
                    $is_parent_show = is_parent_active($current_page, $finance_pages) ? 'show' : '';
                    if ($show_finance_management): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white collapse-toggle <?php echo $is_parent_open == 'true' ? 'active' : ''; ?>"
                                href="#<?php echo $collapse_id; ?>"
                                data-bs-toggle="collapse"
                                aria-expanded="<?php echo $is_parent_open; ?>">
                                <i class="fas fa-money-check-alt me-2"></i>Finance Management <i class="fas fa-chevron-down ms-auto rotate"></i>
                            </a>
                            <div class="collapse submenu-collapse <?php echo $is_parent_show; ?>" id="<?php echo $collapse_id; ?>">
                                <ul class="nav flex-column sub-menu">
                                    <?php if ($user_role === 'accountant' || $user_role === 'admin' || user_has_permission($link, 'manage_payment_types')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'manage_payment_types.php' ? 'active' : ''; ?>" href="manage_payment_types.php"><i class="fas fa-tags me-2"></i>Manage Types</a></li>
                                    <?php endif; ?>
                                    <?php if ($user_role === 'accountant' || $user_role === 'admin' || user_has_permission($link, 'modify_finance_records')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'modify_records.php' ? 'active' : ''; ?>" href="modify_records.php"><i class="fas fa-edit me-2"></i>Modify Records</a></li>
                                    <?php endif; ?>
                                    <?php if ($user_role === 'accountant' || $user_role === 'admin' || user_has_permission($link, 'record_payments')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'record_payments.php' ? 'active' : ''; ?>" href="record_payments.php"><i class="fas fa-file-invoice me-2"></i>Payments</a></li>
                                    <?php endif; ?>
                                    <?php if ($user_role === 'accountant' || $user_role === 'admin' || user_has_permission($link, 'record_expenses')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'record_expenses.php' ? 'active' : ''; ?>" href="record_expenses.php"><i class="fas fa-file-invoice-dollar me-2"></i> Expenses</a></li>
                                    <?php endif; ?>
                                    <?php if ($user_role === 'accountant' || $user_role === 'admin' || user_has_permission($link, 'record_benefits')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'record_benefits.php' ? 'active' : ''; ?>" href="record_benefits.php"><i class="fas fa-gift me-2"></i>Benefits</a></li>
                                    <?php endif; ?>
                                    <?php if ($user_role === 'accountant' || $user_role === 'admin' || user_has_permission($link, 'transfer_funds')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'transfer_funds.php' ? 'active' : ''; ?>" href="transfer_funds.php"><i class="fas fa-exchange-alt me-2"></i>Transfer Funds</a></li>
                                    <?php endif; ?>
                                    <?php if ($user_role === 'accountant' || $user_role === 'admin' || user_has_permission($link, 'record_donations')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'record_donations.php' ? 'active' : ''; ?>" href="record_donations.php"><i class="fas fa-gifts me-2"></i>Other Income/Donations</a></li>
                                    <?php endif; ?>
                                     <?php if (user_has_permission($link, 'manage_messages')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'admin_config_finance.php' ? 'active' : ''; ?>" href="admin_config_finance.php"><i class="fas fa-file-invoice-dollar me-2"></i>Finance Config</a></li>
                                    <?php endif; ?>
                                    
                                    
            
                                </ul>
                            </div>
                        </li>
                    <?php endif; ?>
                    <?php if ($user_role === 'admin'): ?>
                        <?php
                        $show_admin_content = user_has_permission($link, 'manage_members') || user_has_permission($link, 'view_member_directory') || user_has_permission($link, 'manage_news') || user_has_permission($link, 'manage_messages');
                        $is_admin_content_open = is_parent_active($current_page, $admin_content_pages) ? 'true' : 'false';
                        $is_admin_content_show = is_parent_active($current_page, $admin_content_pages) ? 'show' : '';
                        if ($show_admin_content):
                        ?>
                        <li class="nav-item">
                            <a class="nav-link text-white collapse-toggle <?php echo $is_admin_content_open == 'true' ? 'active' : ''; ?>"
                                href="#adminContentCollapse" data-bs-toggle="collapse" aria-expanded="<?php echo $is_admin_content_open; ?>">
                                <i class="fas fa-users-cog me-2"></i>Member & Content <i class="fas fa-chevron-down ms-auto rotate"></i>
                            </a>
                            <div class="collapse submenu-collapse <?php echo $is_admin_content_show; ?>" id="adminContentCollapse">
                                <ul class="nav flex-column sub-menu">
                                    <?php if (user_has_permission($link, 'manage_members')): ?>
                                    <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'member_management.php' ? 'active' : ''; ?>" href="member_management.php"><i class="fas fa-users-cog me-2"></i>Manage Members</a></li>
                                    <?php endif; ?>
                                    <?php if (user_has_permission($link, 'view_member_directory')): ?>
                                    <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'member_directory.php' ? 'active' : ''; ?>" href="member_directory.php"><i class="fas fa-users me-2"></i>Club Directory</a></li>
                                    <?php endif; ?>
                                    <?php if (user_has_permission($link, 'manage_news')): ?>
                                    <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'announcement_management.php' ? 'active' : ''; ?>" href="announcement_management.php"><i class="fas fa-bullhorn me-2"></i>Announcements</a></li>
                                    <?php endif; ?>
                                    <?php if (user_has_permission($link, 'manage_messages')): ?>
                                    <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'messages_admin.php' ? 'active' : ''; ?>" href="messages_admin.php"><i class="fas fa-envelope me-2"></i>Messages</a></li>
                                    <?php endif; ?>
                                   <?php if (user_has_permission($link, 'manage_messages')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'role_permissions.php' ? 'active' : ''; ?>" href="role_permissions.php"><i class="fas fa-user-shield me-2"></i>Role Permissions</a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </li>
                        <?php endif; ?>
                        
                        <!-- NEW: Settings Submenu for Admin Role -->
                        <?php
                        $show_admin_settings = user_has_permission($link, 'manage_roles') || user_has_permission($link, 'manage_finance_config');
                        $is_admin_settings_open = is_parent_active($current_page, $admin_settings_pages) ? 'true' : 'false';
                        $is_admin_settings_show = is_parent_active($current_page, $admin_settings_pages) ? 'show' : '';
                        if ($show_admin_settings):
                        ?>
                        <li class="nav-item">
                            <a class="nav-link text-white collapse-toggle <?php echo $is_admin_settings_open == 'true' ? 'active' : ''; ?>"
                                href="#adminSettingsCollapse" data-bs-toggle="collapse" aria-expanded="<?php echo $is_admin_settings_open; ?>">
                                <i class="fas fa-wrench me-2"></i>Settings <i class="fas fa-chevron-down ms-auto rotate"></i>
                            </a>
                            <div class="collapse submenu-collapse <?php echo $is_admin_settings_show; ?>" id="adminSettingsCollapse">
                                <ul class="nav flex-column sub-menu">
                                    <?php if (user_has_permission($link, 'manage_finance_config')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'admin_config_finance.php' ? 'active' : ''; ?>" href="admin_config_finance.php"><i class="fas fa-file-invoice-dollar me-2"></i>Finance Config</a></li>
                                    <?php endif; ?>
                                    <?php if (user_has_permission($link, 'manage_roles')): ?>
                                        <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'role_permissions.php' ? 'active' : ''; ?>" href="role_permissions.php"><i class="fas fa-user-shield me-2"></i>Role Permissions</a></li>
                                    <?php endif; ?>
                                </ul>
                            </div>
                        </li>
                        <?php endif; ?>
                        <!-- END NEW: Settings Submenu for Admin Role -->

                        <?php if (user_has_permission($link, 'manage_forms')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo $current_page == 'form_builder.php' ? 'active' : ''; ?>" href="form_builder.php">
                                <i class="fas fa-file-alt me-2"></i>Form Builder
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (user_has_permission($link, 'manage_obligations')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo $current_page == 'manage_obligations.php' ? 'active' : ''; ?>" href="manage_obligations.php">
                                <i class="fas fa-handshake me-2"></i>Obligations
                            </a>
                        </li>
                        <?php endif; ?>
                        <?php if (user_has_permission($link, 'view_token_store')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo $current_page == 'token_store.php' ? 'active' : ''; ?>" href="token_store.php">
                                <i class="fas fa-coins me-2"></i>Token Store
                            </a>
                        </li>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php
                    $show_financial_reports = user_has_permission($link, 'view_payments') || user_has_permission($link, 'view_expenses') || user_has_permission($link, 'view_debts') || user_has_permission($link, 'view_benefits');
                    $is_fin_report_open = is_parent_active($current_page, $financial_reports_pages) ? 'true' : 'false';
                    $is_fin_report_show = is_parent_active($current_page, $financial_reports_pages) ? 'show' : '';
                    if ($show_financial_reports):
                    ?>
                    <li class="nav-item">
                        <a class="nav-link text-white collapse-toggle <?php echo $is_fin_report_open == 'true' ? 'active' : ''; ?>"
                            href="#financialReportsCollapse" data-bs-toggle="collapse" aria-expanded="<?php echo $is_fin_report_open; ?>">
                            <i class="fas fa-chart-bar me-2"></i>Financials & Reports <i class="fas fa-chevron-down ms-auto rotate"></i>
                        </a>
                        <div class="collapse submenu-collapse <?php echo $is_fin_report_show; ?>" id="financialReportsCollapse">
                            <ul class="nav flex-column sub-menu">
                                <?php if (user_has_permission($link, 'view_payments')): ?>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'financial_summary.php' ? 'active' : ''; ?>" href="financial_summary.php"><i class="fas fa-file-invoice-dollar me-2"></i>Financial Summary</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_payments')): ?>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'fund_requests_report.php' ? 'active' : ''; ?>" href="fund_requests_report.php"><i class="fas fa-file-invoice-dollar me-2"></i>Fund Request Report</a></li>
                                <?php endif; ?>
                                
                            </ul>
                        </div>
                    </li>
                    <?php endif; ?>
                    
                    <?php if ($user_role === 'accountant' && user_has_permission($link, 'view_member_directory')): ?>
                        <li class="nav-item">
                            <a class="nav-link text-white <?php echo $current_page == 'member_directory.php' ? 'active' : ''; ?>" href="member_directory.php">
                                <i class="fas fa-users me-2"></i>Club Directory
                            </a>
                        </li>
                    <?php endif; ?>
                <?php elseif ($user_role === 'super_admin'): ?>
                    <li class="nav-item">
                        <a class="nav-link text-white <?php echo $current_page == 'super_admin_dashboard.php' ? 'active' : ''; ?>" href="super_admin_dashboard.php">
                            <i class="fas fa-tachometer-alt me-2"></i>Super Admin Dashboard
                        </a>
                    </li>
                    <?php
                    $show_sa_settings = user_has_permission($link, 'manage_bank_settings') ||
                                        user_has_permission($link, 'manage_token_settings') ||
                                        user_has_permission($link, 'view_settings');
                    
                    $is_sa_parent_open = is_parent_active($current_page, $sa_settings_pages) ? 'true' : 'false';
                    $is_sa_parent_show = is_parent_active($current_page, $sa_settings_pages) ? 'show' : '';
                    if ($show_sa_settings):
                    ?>
                    <li class="nav-item">
                        <a class="nav-link text-white collapse-toggle <?php echo $is_sa_parent_open == 'true' ? 'active' : ''; ?>"
                            href="#saSettingsCollapse" data-bs-toggle="collapse" aria-expanded="<?php echo $is_sa_parent_open; ?>">
                            <i class="fas fa-cogs me-2"></i>System Settings <i class="fas fa-chevron-down ms-auto rotate"></i>
                        </a>
                        <div class="collapse submenu-collapse <?php echo $is_sa_parent_show; ?>" id="saSettingsCollapse">
                            <ul class="nav flex-column sub-menu">
                                <?php if (user_has_permission($link, 'manage_bank_settings')): ?>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'bank_settings.php' ? 'active' : ''; ?>" href="bank_settings.php"><i class="fas fa-university me-2"></i>Bank Settings</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'manage_token_settings')): ?>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'token_settings.php' ? 'active' : ''; ?>" href="token_settings.php"><i class="fas fa-cog me-2"></i>Token Settings</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_settings')): ?>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'admin_settings.php' ? 'active' : ''; ?>" href="admin_settings.php"><i class="fas fa-tools me-2"></i>Admin Settings</a></li>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'role_permissions.php' ? 'active' : ''; ?>" href="role_permissions.php"><i class="fas fa-user-shield me-2"></i>Role Permissions</a></li>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'smtp_setup.php' ? 'active' : ''; ?>" href="smtp_setup.php"><i class="fas fa-envelope-open-text me-2"></i>SMTP Setup</a></li>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'admin_config_finance.php' ? 'active' : ''; ?>" href="admin_config_finance.php"><i class="fas fa-file-invoice-dollar me-2"></i>Finance Config</a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                    <?php endif; ?>
                    
                    <?php
                    $show_sa_token = user_has_permission($link, 'manage_token_purchases') || user_has_permission($link, 'view_token_store');
                    $is_sa_token_open = is_parent_active($current_page, $sa_token_pages) ? 'true' : 'false';
                    $is_sa_token_show = is_parent_active($current_page, $sa_token_pages) ? 'show' : '';
                    if ($show_sa_token):
                    ?>
                    <li class="nav-item">
                        <a class="nav-link text-white collapse-toggle <?php echo $is_sa_token_open == 'true' ? 'active' : ''; ?>"
                            href="#saTokenCollapse" data-bs-toggle="collapse" aria-expanded="<?php echo $is_sa_token_open; ?>">
                            <i class="fas fa-coins me-2"></i>Token Management <i class="fas fa-chevron-down ms-auto rotate"></i>
                        </a>
                        <div class="collapse submenu-collapse <?php echo $is_sa_token_show; ?>" id="saTokenCollapse">
                            <ul class="nav flex-column sub-menu">
                                <?php if (user_has_permission($link, 'manage_token_purchases')): ?>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'manage_token_purchases.php' ? 'active' : ''; ?>" href="manage_token_purchases.php"><i class="fas fa-shopping-cart me-2"></i>Manage Purchases</a></li>
                                <?php endif; ?>
                                <?php if (user_has_permission($link, 'view_token_store')): ?>
                                <li class="nav-item"><a class="nav-link text-white <?php echo $current_page == 'token_store.php' ? 'active' : ''; ?>" href="token_store.php"><i class="fas fa-store me-2"></i>Token Store</a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </li>
                    <?php endif; ?>
                <?php endif; // End main role check ?>
            <?php endif; // End logged-in check ?>
        </ul>
        <?php if (is_logged_in()): ?>
        <div class="mt-auto logout-container">
            <a href="logout.php" class="logout-btn btn text-white w-100">Logout</a>
        </div>
        <?php endif; ?>
    </div>
</nav>
<!-- 
    NOTE: The <style> from the original file should be in your header.php or a main CSS file.
    I am removing the <style> block from this file as it doesn't belong here
    and was not in your last provided code.
-->