<?php
// members/id-card.php
require_once '../includes/functions.php';
require_once '../includes/db_config.php';
require_once '../vendor/tcpdf/tcpdf.php';

if (!is_logged_in() || !is_admin()) exit;

$id = (int)($_GET['id'] ?? 0);
$user = $link->query("SELECT * FROM users WHERE id = $id")->fetch_assoc();
if (!$user) exit;

$pdf = new TCPDF('L', 'mm', [85.6, 54], true, 'UTF-8', false);
$pdf->SetMargins(5, 5, 5);
$pdf->AddPage();

$photo = $user['profile_image'] ? "../uploads/profiles/{$user['profile_image']}" : "../assets/default.png";
if (!file_exists($photo)) $photo = "../assets/default.png";

$html = '
<table border="1" cellpadding="5" style="width:100%; font-size:10px;">
<tr>
    <td width="30%" rowspan="5">
        <img src="'.$photo.'" width="70" height="80">
    </td>
    <td width="70%"><strong>'.$user['full_name'].'</strong></td>
</tr>
<tr><td>ID: <strong>'.$user['member_id'].'</strong></td></tr>
<tr><td>Phone: '.$user['phone'].'</td></tr>
<tr><td>Expiry: '.format_date($user['membership_expiry']).'</td></tr>
<tr><td>Status: <span style="color:green;">'.$user['membership_status'].'</span></td></tr>
</table>
';

$pdf->writeHTML($html);
$pdf->Output("ID-Card-{$user['member_id']}.pdf", 'I');