<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

$message = '';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $email = sanitize_input($_POST['email']);

    // Check if the email exists in the users table
    $sql = "SELECT id FROM users WHERE email = ?";
    if ($stmt = mysqli_prepare($link, $sql)) {
        mysqli_stmt_bind_param($stmt, "s", $email);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_store_result($stmt);

        if (mysqli_stmt_num_rows($stmt) > 0) {
            // Email exists, generate a unique token
            $token = bin2hex(random_bytes(32));
            $expires_at = date('Y-m-d H:i:s', strtotime('+1 hour'));

            // Delete any old tokens for this email
            $sql_delete = "DELETE FROM password_resets WHERE email = ?";
            $stmt_delete = mysqli_prepare($link, $sql_delete);
            mysqli_stmt_bind_param($stmt_delete, "s", $email);
            mysqli_stmt_execute($stmt_delete);
            mysqli_stmt_close($stmt_delete);

            // Insert the new token into the password_resets table
            $sql_insert = "INSERT INTO password_resets (email, token, expires_at) VALUES (?, ?, ?)";
            $stmt_insert = mysqli_prepare($link, $sql_insert);
            mysqli_stmt_bind_param($stmt_insert, "sss", $email, $token, $expires_at);
            mysqli_stmt_execute($stmt_insert);
            mysqli_stmt_close($stmt_insert);

            // Construct and send the password reset email
            $reset_link = "http://" . $_SERVER['HTTP_HOST'] . "/club_portal/reset_password.php?token=" . $token;
            $subject = "Password Reset Request";
            $body = "Hi,<br><br>You requested a password reset. Click the following link to reset your password:<br><a href='" . htmlspecialchars($reset_link) . "'>Reset Password</a><br><br>If you did not request this, please ignore this email.";

            $mail_sent = send_mail($email, $subject, $body);

            if ($mail_sent === true) {
                $message = "A password reset link has been sent to your email address.";
            } else {
                $message = "Error sending email: " . $mail_sent;
            }

        } else {
            $message = "No user found with that email address.";
        }
        mysqli_stmt_close($stmt);
    }
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <main class="col-md-12 main-content">
            <h2>Forgot Password</h2>
            <?php if ($message): ?>
                <div class="message <?php echo strpos($message, 'Error') !== false ? 'error-message' : 'success-message'; ?>">
                    <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>
            <div class="form-container">
                <p>Enter your email address to receive a password reset link.</p>
                <form action="forgot_password.php" method="post">
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" name="email" id="email" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Request Reset Link</button>
                </form>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>