<?php
// This file handles the recording of club expenses.

require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Check if the user is logged in and has admin privileges.
if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
}

$message = '';

// Handle form submission to add a new expense record.
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_expense'])) {
    $expense_date = $_POST['expense_date'];
    $description = $_POST['description'];
    $amount = floatval($_POST['amount']);
    $category = $_POST['category'];
    
    // Validate required fields
    if (empty($expense_date) || empty($description) || empty($amount) || empty($category)) {
        $message = "Please fill in all fields.";
    } else {
        // Use a prepared statement to securely insert the data.
        $sql = "INSERT INTO expenses (expense_date, description, amount, category) VALUES (?, ?, ?, ?)";
        
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "ssds", $expense_date, $description, $amount, $category);
            
            if (mysqli_stmt_execute($stmt)) {
                $message = "Expense recorded successfully!";
            } else {
                $message = "Error recording expense: " . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        } else {
            $message = "Database error: Could not prepare statement.";
        }
    }
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Record Expense</h2>
            
            <?php if ($message): ?>
                <div class="message success-message"><?php echo htmlspecialchars($message ?? ''); ?></div>
            <?php endif; ?>

            <div class="form-container">
                <form action="expenses.php" method="post">
                    <div class="form-group">
                        <label for="expense_date">Date:</label>
                        <input type="date" id="expense_date" name="expense_date" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="description">Description:</label>
                        <input type="text" id="description" name="description" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="amount">Amount:</label>
                        <input type="number" id="amount" name="amount" class="form-control" step="0.01" required>
                    </div>
                    <div class="form-group">
                        <label for="category">Category:</label>
                        <select id="category" name="category" class="form-control" required>
                            <option value="">Select a category</option>
                            <option value="Operational">Operational</option>
                            <option value="Events">Events</option>
                            <option value="Supplies">Supplies</option>
                            <option value="Maintenance">Maintenance</option>
                            <option value="Other">Other</option>
                        </select>
                    </div>
                    <button type="submit" name="submit_expense" class="btn btn-primary">Record Expense</button>
                </form>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>