<?php
require_once 'includes/db_config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['form_id']) || !isset($_POST['form_structure_data'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Invalid request.']);
    exit();
}

$form_id = intval($_POST['form_id']);
$form_structure_data = json_decode($_POST['form_structure_data'], true);

// Start a transaction for data integrity
mysqli_begin_transaction($link);

try {
    // Delete existing steps and fields for this form
    $stmt = mysqli_prepare($link, "DELETE FROM form_steps WHERE form_id = ?");
    mysqli_stmt_bind_param($stmt, "i", $form_id);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);

    // Loop through steps and insert them
    $step_number = 1;
    foreach ($form_structure_data['steps'] as $step) {
        $stmt = mysqli_prepare($link, "INSERT INTO form_steps (form_id, step_number, step_name) VALUES (?, ?, ?)");
        mysqli_stmt_bind_param($stmt, "iis", $form_id, $step_number, $step['name']);
        mysqli_stmt_execute($stmt);
        $step_id = mysqli_insert_id($link);
        mysqli_stmt_close($stmt);

        // Loop through fields and insert them
        foreach ($step['fields'] as $field) {
            $field_options = isset($field['options']) ? json_encode($field['options']) : null;
            $conditional_logic = isset($field['conditional_logic']) ? json_encode($field['conditional_logic']) : null;
            $is_required = isset($field['required']) && $field['required'] ? 1 : 0;
            
            $stmt = mysqli_prepare($link, "INSERT INTO form_fields (step_id, field_type, field_label, field_name, is_required, field_options, conditional_logic, field_order) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            mysqli_stmt_bind_param($stmt, "isssisss", $step_id, $field['type'], $field['label'], $field['name'], $is_required, $field_options, $conditional_logic, $field['order']);
            mysqli_stmt_execute($stmt);
            mysqli_stmt_close($stmt);
        }
        $step_number++;
    }

    mysqli_commit($link);
    echo json_encode(['success' => true, 'message' => 'Form saved successfully.']);

} catch (Exception $e) {
    mysqli_rollback($link);
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to save form: ' . $e->getMessage()]);
}

mysqli_close($link);
?>