<?php
session_start();
define('IN_REPORTS', true);
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Enable error reporting (development), but exclude deprecation warnings
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL & ~E_DEPRECATED);

// Check database connection
if (!$link) {
    error_log("Database connection failed: " . mysqli_connect_error());
    die("ERROR: Could not connect to database.");
}

// Check if user is logged in
if (!is_logged_in()) {
    redirect("login.php");
}

$is_admin = is_admin();
$currency_symbol = get_setting('currency_symbol', $link) ?? '₦';
if ($currency_symbol === '?' || empty($currency_symbol)) {
    $currency_symbol = '₦';
    error_log("Currency symbol retrieved as '?' or empty, defaulting to '₦'");
}

// Filter settings
$record_type = isset($_GET['record_type']) && in_array($_GET['record_type'], ['all', 'income', 'expenses', 'debts', 'benefits']) ? $_GET['record_type'] : 'all';
$start_date = isset($_GET['start_date']) ? trim($_GET['start_date']) : date('Y-m-d', strtotime('-1 year'));
$end_date = isset($_GET['end_date']) ? trim($_GET['end_date']) : date('Y-m-d', strtotime('+1 year'));
$search = isset($_GET['search']) ? trim($_GET['search']) : '';
$type_filter = isset($_GET['type_filter']) ? trim($_GET['type_filter']) : '';

// Validate dates
if (!strtotime($start_date) || !strtotime($end_date)) {
    $start_date = date('Y-m-d', strtotime('-1 year'));
    $end_date = date('Y-m-d', strtotime('+1 year'));
    error_log("Invalid date format for start_date or end_date, using defaults: start_date=$start_date, end_date=$end_date");
}
if (strtotime($start_date) > strtotime($end_date)) {
    $temp = $start_date;
    $start_date = $end_date;
    $end_date = $temp;
    error_log("Swapped start_date and end_date to ensure start_date <= end_date: start_date=$start_date, end_date=$end_date");
}

// Include data fetching logic
if (!file_exists('includes/reports_data.php')) {
    error_log("Data file not found: includes/reports_data.php");
    die("ERROR: Data processing file is missing.");
}
require_once 'includes/reports_data.php';

// Handle PDF export
if (isset($_GET['export_pdf']) && $is_admin) {
    $reports_pdf_path = 'includes/reports_pdf.php';
    if (!file_exists($reports_pdf_path)) {
        error_log("PDF file not found: $reports_pdf_path");
        die("ERROR: PDF generation file is missing.");
    }
    if (!file_exists('includes/tcpdf/tcpdf.php')) {
        error_log("TCPDF library not found: includes/tcpdf/tcpdf.php");
        die("ERROR: TCPDF library is missing.");
    }
    error_log("Attempting to include $reports_pdf_path");
    $include_result = include_once $reports_pdf_path;
    if ($include_result === false) {
        error_log("Failed to include $reports_pdf_path");
        die("ERROR: Could not load PDF generation file.");
    }
    if (!function_exists('generatePDF')) {
        error_log("Function generatePDF not defined after including $reports_pdf_path");
        die("ERROR: PDF generation function is not available.");
    }

    $export_table = $_GET['export_pdf'];
    $data = [];
    $columns = [];
    $title = '';
    if ($export_table === 'income') {
        $data = $income;
        $columns = ['Member ID', 'Member Name', 'Payment Type', 'Amount', 'Status', 'Date', 'Payment Date'];
        $title = 'Income Report';
    } elseif ($export_table === 'expenses') {
        $data = $expenses;
        $columns = ['Type', 'Amount', 'Description', 'Date'];
        $title = 'Expenses Report';
    } elseif ($export_table === 'benefits') {
        $data = $benefits;
        $columns = ['Member ID', 'Member Name', 'Benefit Type', 'Amount', 'Date'];
        $title = 'Benefits Report';
    } elseif ($export_table === 'debts') {
        $data = $debts;
        $columns = ['Member ID', 'Member Name', 'Payment Type', 'Required Amount', 'Total Paid', 'Debt', 'Payment Cycle', 'Due Date'];
        $title = 'Debt Report';
    } elseif ($export_table === 'type_summaries') {
        $data = array_merge(
            array_map(function($row) {
                return [
                    'section' => 'Payments',
                    'type_name' => $row['type_name'],
                    'required_amount' => $row['required_amount'],
                    'total_paid' => $row['total_paid'],
                    'total_debt' => $row['total_debt']
                ];
            }, $payment_types_summary),
            array_map(function($row) {
                return [
                    'section' => 'Expenses',
                    'type_name' => $row['type_name'],
                    'total' => $row['total']
                ];
            }, $expense_types_summary),
            array_map(function($row) {
                return [
                    'section' => 'Benefits',
                    'type_name' => $row['type_name'],
                    'total' => $row['total']
                ];
            }, $benefit_types_summary)
        );
        $columns = ['Section', 'Type', 'Required Amount', 'Total Paid', 'Total Debt', 'Total'];
        $title = 'Type Summaries Report';
    }
    if ($data && $columns && $title) {
        error_log("Generating PDF for $title with " . count($data) . " records");
        @generatePDF($title, $data, $columns, $currency_symbol, $start_date, $end_date, $link);
        exit;
    } else {
        error_log("Invalid export_pdf parameter: $export_table");
        header("Location: reports.php?error=invalid_export");
        exit;
    }
}

// Include view rendering
if (!file_exists('includes/reports_view.php')) {
    error_log("View file not found: includes/reports_view.php");
    die("ERROR: View rendering file is missing.");
}
require_once 'includes/reports_view.php';
?>