<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Check if user is logged in
if (!is_logged_in()) {
    redirect("login.php");
}

$user_id = $_SESSION['user_id'];

// Fetch all payments for the logged-in user
$sql = "SELECT * FROM payments WHERE user_id = ? ORDER BY created_at DESC";
$stmt = mysqli_prepare($link, $sql);
mysqli_stmt_bind_param($stmt, "i", $user_id);
mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

$payment_history = [];
if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $payment_history[] = $row;
    }
}
mysqli_stmt_close($stmt);
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>My Payment History</h2>

            <div class="card">
                <div class="card-header">Payment History</div>
                <div class="card-body">
                    <div class="payment-history-list">
                        <?php if (empty($payment_history)): ?>
                            <p>You have no payment history yet.</p>
                        <?php else: ?>
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Amount</th>
                                        <th>Type</th>
                                        <th>Description</th>
                                        <th>Status</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($payment_history as $payment): ?>
                                        <tr>
                                            <td><?php echo date('M j, Y', strtotime($payment['created_at'])); ?></td>
                                            <td>$<?php echo htmlspecialchars(number_format($payment['amount'], 2)); ?></td>
                                            <td><?php echo htmlspecialchars(ucfirst($payment['payment_type'])); ?></td>
                                            <td><?php echo htmlspecialchars($payment['description']); ?></td>
                                            <td><span class="status-badge <?php echo strtolower($payment['status']); ?>"><?php echo htmlspecialchars(ucfirst($payment['status'])); ?></span></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>