<?php
// members/edit.php
require_once '../includes/functions.php';
require_once '../includes/db_config.php';
if (!is_logged_in() || !is_admin()) redirect("login.php");

$id = (int)($_GET['id'] ?? 0);
$user = $link->query("SELECT * FROM users WHERE id = $id")->fetch_assoc();
if (!$user) redirect("list.php");

if ($_POST) {
    $full_name = sanitize_input($_POST['full_name']);
    $email = sanitize_input($_POST['email']);
    $phone = sanitize_input($_POST['phone']);
    $address = sanitize_input($_POST['address']);
    $sex = sanitize_input($_POST['sex']);
    $expiry = $_POST['membership_expiry'] ?: null;
    $status = sanitize_input($_POST['membership_status']);

    // Handle file upload
    $profile_image = $user['profile_image'];
    if ($_FILES['profile_image']['name']) {
        $ext = pathinfo($_FILES['profile_image']['name'], PATHINFO_EXTENSION);
        $profile_image = "profile_{$id}_" . time() . ".$ext";
        move_uploaded_file($_FILES['profile_image']['tmp_name'], "../uploads/profiles/$profile_image");
    }

    $stmt = $link->prepare("UPDATE users SET full_name=?, email=?, phone=?, address=?, sex=?, membership_expiry=?, membership_status=?, profile_image=? WHERE id=?");
    $stmt->bind_param("ssssssssi", $full_name, $email, $phone, $address, $sex, $expiry, $status, $profile_image, $id);
    $stmt->execute();
    redirect("view.php?id=$id");
}
?>

<?php include '../includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php include '../includes/sidebar.php'; ?>
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <h2>Edit Member</h2>
            <form method="POST" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Full Name</label>
                            <input type="text" name="full_name" class="form-control" value="<?=htmlspecialchars($user['full_name'])?>" required>
                        </div>
                        <div class="mb-3">
                            <label>Email</label>
                            <input type="email" name="email" class="form-control" value="<?=htmlspecialchars($user['email'])?>" required>
                        </div>
                        <div class="mb-3">
                            <label>Phone</label>
                            <input type="text" name="phone" class="form-control" value="<?=htmlspecialchars($user['phone'])?>">
                        </div>
                        <div class="mb-3">
                            <label>Sex</label>
                            <select name="sex" class="form-control">
                                <option <?=($user['sex']=='Male')?'selected':''?>>Male</option>
                                <option <?=($user['sex']=='Female')?'selected':''?>>Female</option>
                                <option <?=($user['sex']=='Other')?'selected':''?>>Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="mb-3">
                            <label>Address</label>
                            <textarea name="address" class="form-control" rows="3"><?=htmlspecialchars($user['address'])?></textarea>
                        </div>
                        <div class="mb-3">
                            <label>Membership Expiry</label>
                            <input type="date" name="membership_expiry" class="form-control" value="<?=$user['membership_expiry']?>">
                        </div>
                        <div class="mb-3">
                            <label>Status</label>
                            <select name="membership_status" class="form-control">
                                <option>Approved</option>
                                <option>Pending</option>
                                <option>Rejected</option>
                                <option>Banned</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label>Profile Image</label>
                            <input type="file" name="profile_image" class="form-control" accept="image/*">
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">Save Changes</button>
            </form>
        </main>
    </div>
</div>
<?php include '../includes/footer.php'; ?>