<?php
/**
 * financial_utils.php
 * -----------------------------------------------------------------------
 * Helper functions used by financial_summary.php and financial_queries.php
 * -----------------------------------------------------------------------
 */

// Prevent direct access
if (!defined('ABSPATH') && !defined('IN_REPORTS')) {
    exit('Direct access not allowed.');
}

if (!function_exists('sanitize_filter')) {
    function sanitize_filter($input, $valid_options, $default) {
        return in_array($input, $valid_options, true) ? $input : $default;
    }
}

if (!function_exists('validate_type_filter')) {
    function validate_type_filter($type_filter, $record_type) {
        if ($type_filter === '') {
            return '';
        }

        $type_parts    = explode('_', $type_filter, 2);
        $type_category = $type_parts[0] ?? '';
        $type_name     = $type_parts[1] ?? '';

        $allowed = ['income', 'expense', 'benefit'];
        if ($type_category && $type_name && in_array($type_category, $allowed, true)) {
            $matches = ($record_type === 'all')
                || ($record_type === ($type_category === 'income' ? 'income' : $type_category . 's'));

            if ($matches) {
                if ($type_category === 'income') {
                    return " AND po.payment_type = ?";
                } elseif ($type_category === 'expense') {
                    return " AND et.type_name = ?";
                } elseif ($type_category === 'benefit') {
                    return " AND bt.type_name = ?";
                }
            }
        }

        error_log("Invalid type_filter format: $type_filter");
        return '';
    }
}

/* -----------------------------------------------------------------------
 * REMOVED: build_time_filter() 
 * Now defined only in financial_queries.php to avoid redeclaration
 * ----------------------------------------------------------------------- */

if (!function_exists('get_type_options')) {
    /**
     * Generate <option> tags for type dropdowns (income, expense, benefit)
     */
    function get_type_options($db, $record_type = '', $selected = '') {
        $options = '<option value="">All Types</option>';

        $record_type = strtolower(trim($record_type));
        $is_all = in_array($record_type, ['', 'all']);

        if ($is_all || $record_type === 'income') {
            $sql = "SELECT DISTINCT payment_type 
                    FROM payments 
                    WHERE payment_type IS NOT NULL 
                      AND TRIM(payment_type) != '' 
                    ORDER BY payment_type";
            $result = $db->query($sql);
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $val = 'income_' . htmlspecialchars($row['payment_type'], ENT_QUOTES);
                    $sel = ($selected === $val) ? ' selected' : '';
                    $label = htmlspecialchars($row['payment_type'], ENT_QUOTES);
                    $options .= "<option value=\"{$val}\"{$sel}>{$label}</option>";
                }
            }
        }

        if ($is_all || $record_type === 'expenses') {
            $sql = "SELECT type_name FROM expense_types WHERE type_name IS NOT NULL AND TRIM(type_name) != '' ORDER BY type_name";
            $result = $db->query($sql);
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $val = 'expense_' . htmlspecialchars($row['type_name'], ENT_QUOTES);
                    $sel = ($selected === $val) ? ' selected' : '';
                    $label = htmlspecialchars($row['type_name'], ENT_QUOTES);
                    $options .= "<option value=\"{$val}\"{$sel}>{$label}</option>";
                }
            }
        }

        if ($is_all || $record_type === 'benefits') {
            $sql = "SELECT type_name FROM benefit_types WHERE type_name IS NOT NULL AND TRIM(type_name) != '' ORDER BY type_name";
            $result = $db->query($sql);
            if ($result) {
                while ($row = $result->fetch_assoc()) {
                    $val = 'benefit_' . htmlspecialchars($row['type_name'], ENT_QUOTES);
                    $sel = ($selected === $val) ? ' selected' : '';
                    $label = htmlspecialchars($row['type_name'], ENT_QUOTES);
                    $options .= "<option value=\"{$val}\"{$sel}>{$label}</option>";
                }
            }
        }

        return $options;
    }
}
?>