<?php
// This file handles the recording of benefits awarded to members.

require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Check if the user is logged in and has admin privileges.
if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
}

$message = '';

// Handle form submission to add a new benefit record.
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['submit_benefit'])) {
    $member_id = intval($_POST['member_id']);
    $benefit_type = $_POST['benefit_type'];
    $description = $_POST['description'];
    $date_awarded = $_POST['date_awarded'];
    
    // Validate required fields
    if (empty($member_id) || empty($benefit_type) || empty($description) || empty($date_awarded)) {
        $message = "Please fill in all fields.";
    } else {
        // Use a prepared statement to securely insert the data.
        $sql = "INSERT INTO benefits (member_id, benefit_type, description, date_awarded) VALUES (?, ?, ?, ?)";
        
        if ($stmt = mysqli_prepare($link, $sql)) {
            mysqli_stmt_bind_param($stmt, "isss", $member_id, $benefit_type, $description, $date_awarded);
            
            if (mysqli_stmt_execute($stmt)) {
                $message = "Benefit recorded successfully!";
            } else {
                $message = "Error recording benefit: " . mysqli_error($link);
            }
            mysqli_stmt_close($stmt);
        } else {
            $message = "Database error: Could not prepare statement.";
        }
    }
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Record Member Benefit</h2>
            
            <?php if ($message): ?>
                <div class="message success-message"><?php echo htmlspecialchars($message ?? ''); ?></div>
            <?php endif; ?>

            <div class="form-container">
                <form action="benefits.php" method="post">
                    <div class="form-group">
                        <label for="member_id">Member ID:</label>
                        <input type="number" id="member_id" name="member_id" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="benefit_type">Benefit Type:</label>
                        <input type="text" id="benefit_type" name="benefit_type" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="description">Description:</label>
                        <textarea id="description" name="description" class="form-control" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="date_awarded">Date Awarded:</label>
                        <input type="date" id="date_awarded" name="date_awarded" class="form-control" required>
                    </div>
                    <button type="submit" name="submit_benefit" class="btn btn-primary">Record Benefit</button>
                </form>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>