<?php
header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="financials_export_' . date('Y-m-d') . '.csv"');
header('Pragma: no-cache');
header('Expires: 0');

require_once '../includes/db_config.php';
require_once '../includes/functions.php';

// Check if the user is an admin
if (!is_admin()) {
    echo "Unauthorized access.";
    exit();
}

try {
    // Open a file handle for output
    $output = fopen('php://output', 'w');

    // Write the CSV header row
    fputcsv($output, ['Member ID', 'Surname', 'Other Names', 'Payment Type', 'Amount Paid', 'Payment Status', 'Payment Date']);

    // SQL query to fetch all financial data
    $sql = "
        SELECT
            u.id AS member_id,
            u.surname,
            u.other_names,
            IFNULL(pt.type_name, 'N/A') AS payment_type,
            IFNULL(p.amount, 'N/A') AS amount_paid,
            IFNULL(p.payment_status, 'Not Paid') AS payment_status,
            IFNULL(p.payment_date, 'N/A') AS payment_date
        FROM
            users u
        LEFT JOIN
            payments p ON u.id = p.member_id
        LEFT JOIN
            payment_types pt ON p.payment_type_id = pt.id
        ORDER BY u.surname ASC, u.other_names ASC;
    ";

    $stmt = $link->prepare($sql);
    $stmt->execute();
    $result = $stmt->get_result();

    // Loop through the results and write each row to the CSV
    while ($row = $result->fetch_assoc()) {
        fputcsv($output, $row);
    }

    // Close the file handle
    fclose($output);

} catch (Exception $e) {
    // Output an error message directly to the CSV file
    echo "An error occurred: " . $e->getMessage();
}

$link->close();
?>
