<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';
session_start();

// Check if user is logged in
if (!is_logged_in()) {
    redirect("login.php");
}

// Fetch all announcements with author information
$announcements = [];
$sql = "SELECT a.id, a.title, a.content, a.created_at, a.views_count, a.author_id, u.full_name, u.profile_picture 
        FROM announcements a
        JOIN users u ON a.author_id = u.id
        ORDER BY a.created_at DESC";
$result = mysqli_query($link, $sql);

if ($result) {
    while ($row = mysqli_fetch_assoc($result)) {
        $announcements[] = $row;
    }
}

// Display message if available
$message = '';
if (isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Announcements</h2>
            
            <?php if ($message): ?>
                <div class="message success-message"><?php echo htmlspecialchars($message); ?></div>
            <?php endif; ?>

            <div class="announcement-list">
                <?php if (!empty($announcements)): ?>
                    <?php foreach ($announcements as $announcement): ?>
                        <div class="announcement-item card mb-3" data-announcement-id="<?php echo htmlspecialchars($announcement['id']); ?>">
                            <div class="card-body">
                                <div class="d-flex align-items-center mb-2">
                                    <img src="<?php echo htmlspecialchars($announcement['profile_picture']); ?>" alt="Profile" class="profile-avatar mr-2">
                                    <span class="announcement-author"><?php echo htmlspecialchars($announcement['full_name']); ?></span>
                                </div>
                                <h4 class="card-title"><?php echo htmlspecialchars($announcement['title']); ?></h4>
                                <div class="announcement-content-summary">
                                    <p class="card-text text-truncate"><?php echo htmlspecialchars($announcement['content']); ?></p>
                                    <a href="#" class="read-more-link">Read more...</a>
                                </div>
                                <div class="announcement-content-full d-none">
                                    <p class="card-text"><?php echo nl2br(htmlspecialchars($announcement['content'])); ?></p>
                                    <a href="#" class="read-less-link">Read less...</a>
                                </div>
                                <small class="text-muted">
                                    Posted: <?php echo htmlspecialchars($announcement['created_at']); ?> |
                                    Views: <span class="views-count" data-id="<?php echo htmlspecialchars($announcement['id']); ?>"><?php echo htmlspecialchars($announcement['views_count']); ?></span>
                                </small>
                                <br>
                                <?php if (is_logged_in() && $_SESSION['user_id'] === $announcement['author_id']): ?>
                                    <form action="delete_announcement.php" method="post" style="display:inline;">
                                        <input type="hidden" name="announcement_id" value="<?php echo htmlspecialchars($announcement['id']); ?>">
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this message?');">Delete</button>
                                    </form>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p>No announcements found.</p>
                <?php endif; ?>
            </div>
        </main>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function() {
    $('.announcement-item').on('click', '.read-more-link', function(e) {
        e.preventDefault();
        const card = $(this).closest('.announcement-item');
        const announcementId = card.data('announcement-id');
        const summary = card.find('.announcement-content-summary');
        const full = card.find('.announcement-content-full');
        
        // Show full content and hide summary
        summary.addClass('d-none');
        full.removeClass('d-none');
        
        // Increment view count via AJAX
        $.ajax({
            url: 'update_view_count.php',
            type: 'POST',
            data: { id: announcementId },
            success: function(response) {
                const data = JSON.parse(response);
                if (data.status === 'success') {
                    card.find('.views-count').text(data.new_count);
                }
            }
        });
    });
    
    $('.announcement-item').on('click', '.read-less-link', function(e) {
        e.preventDefault();
        const card = $(this).closest('.announcement-item');
        const summary = card.find('.announcement-content-summary');
        const full = card.find('.announcement-content-full');
        
        // Show summary and hide full content
        full.addClass('d-none');
        summary.removeClass('d-none');
    });
});
</script>
<?php require_once 'includes/footer.php'; ?>