<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Check if user is logged in
if (!is_logged_in()) {
    redirect("login.php");
}

$user_id = $_SESSION['user_id'];
$admin_id = null;

// Find the ID of the first admin
$sql_admin = "SELECT id FROM users WHERE role = 'admin' LIMIT 1";
$result_admin = mysqli_query($link, $sql_admin);
if ($result_admin && mysqli_num_rows($result_admin) > 0) {
    $row = mysqli_fetch_assoc($result_admin);
    $admin_id = $row['id'];
} else {
    $message = "There is no administrator available to receive messages.";
}

$success_message = '';
$error_message = '';

// Handle new message submission
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['send_message'])) {
    if ($admin_id) {
        $message_content = sanitize_input($_POST['message_content']);
        if (!empty($message_content)) {
            $sql = "INSERT INTO messages (sender_id, recipient_id, message_content, timestamp, is_read) VALUES (?, ?, ?, NOW(), 0)";
            if ($stmt = mysqli_prepare($link, $sql)) {
                mysqli_stmt_bind_param($stmt, "iis", $user_id, $admin_id, $message_content);
                if (mysqli_stmt_execute($stmt)) {
                    $success_message = "Your message has been sent!";
                } else {
                    $error_message = "Failed to send message.";
                }
                mysqli_stmt_close($stmt);
            }
        } else {
            $error_message = "Message content cannot be empty.";
        }
    } else {
        $error_message = "Cannot send message, no admin available.";
    }
}

// Fetch conversation history between the user and the admin
$conversation = [];
if ($admin_id) {
    $sql_conversation = "SELECT sender_id, message_content, timestamp, is_read FROM messages WHERE (sender_id = ? AND recipient_id = ?) OR (sender_id = ? AND recipient_id = ?) ORDER BY timestamp ASC";
    if ($stmt_conv = mysqli_prepare($link, $sql_conversation)) {
        mysqli_stmt_bind_param($stmt_conv, "iiii", $user_id, $admin_id, $admin_id, $user_id);
        mysqli_stmt_execute($stmt_conv);
        $result_conv = mysqli_stmt_get_result($stmt_conv);
        while ($row = mysqli_fetch_assoc($result_conv)) {
            $conversation[] = $row;
        }
        mysqli_stmt_close($stmt_conv);
    }
}
?>

<?php require_once 'includes/header.php'; ?>
<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>My Messages</h2>

            <?php if (!empty($success_message)): ?>
                <div class="alert alert-success"><?php echo $success_message; ?></div>
            <?php endif; ?>
            <?php if (!empty($error_message) || !empty($message)): ?>
                <div class="alert alert-danger"><?php echo !empty($error_message) ? $error_message : $message; ?></div>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">Messages with Admin</div>
                <div class="card-body">
                    <div class="message-container">
                        <div class="message-history">
                            <?php if (empty($conversation)): ?>
                                <p>No messages yet. Send your first question!</p>
                            <?php else: ?>
                                <?php foreach ($conversation as $msg): ?>
                                    <div class="message-bubble <?php echo ($msg['sender_id'] === $user_id) ? 'sent' : 'received'; ?>">
                                        <p class="message-content"><?php echo htmlspecialchars($msg['message_content']); ?></p>
                                        <span class="message-timestamp"><?php echo date('M j, Y, h:i a', strtotime($msg['timestamp'])); ?></span>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                        <div class="message-form">
                            <form action="messages.php" method="post">
                                <textarea name="message_content" class="form-control" rows="3" placeholder="Type your question here..." required></textarea>
                                <button type="submit" name="send_message" class="btn btn-primary mt-2">Send</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>
<?php require_once 'includes/footer.php'; ?>