<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ASSOTRACK || Association Management System</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .hero-section {
            background: #1C2526; /* Dark navy blue for better text readability */
            padding: 100px 0;
            color: white;
            text-shadow: 0 2px 4px rgba(0, 0, 0, 0.5);
        }
        .hero-section p {
            font-size: 1.25rem;
            max-width: 600px;
            margin: 0 auto 2rem;
        }
        .cta-buttons .btn {
            padding: 12px 30px;
            font-size: 1.1rem;
            border-radius: 25px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .cta-buttons .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.3);
        }
        .features-section, .why-choose-section {
            padding: 50px 0;
            background: #ffffff;
        }
        .features-section .feature-card, .why-choose-section .feature-card {
            padding: 20px;
            border-radius: 10px;
            background: #f8f9fa;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        .features-section .feature-card:hover, .why-choose-section .feature-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
        .features-section i, .why-choose-section i {
            font-size: 2.5rem;
            color: #0d6efd;
            margin-bottom: 1rem;
            transition: transform 0.3s ease;
        }
        .features-section .feature-card:hover i, .why-choose-section .feature-card:hover i {
            transform: scale(1.2);
        }
        .feature-card img.gif-icon {
            width: 50px;
            height: 50px;
            margin-bottom: 1rem;
        }
        .call-to-action-section {
            padding: 50px 0;
            background: #e9ecef;
            text-align: center;
        }
        .call-to-action-section .btn {
            padding: 12px 30px;
            font-size: 1.1rem;
            border-radius: 25px;
            margin: 0 10px;
        }
        .call-to-action-section .btn-whatsapp {
            background-color: #25D366;
            color: white;
        }
        .call-to-action-section .btn-whatsapp:hover {
            background-color: #20b358;
        }
        .footer {
            background: #343a40;
            color: white;
            padding: 30px 0;
            margin-top: auto;
        }
        /* Auto-writing text animation styles */
        .auto-writing-container {
            font-size: calc(1.5rem + 1.5vw); /* Responsive font size */
            font-weight: 700;
            margin-bottom: 1rem;
            display: inline-block;
            text-align: center;
            line-height: 1.2; /* Improved readability on smaller screens */
        }
        @media (max-width: 576px) {
            .auto-writing-container {
                font-size: calc(1.2rem + 1.5vw); /* Smaller base for mobile */
            }
        }
        @media (min-width: 1200px) {
            .auto-writing-container {
                font-size: 3rem; /* Cap at original size for large screens */
            }
        }
        .auto-writing {
            position: relative;
            white-space: nowrap;
            overflow: hidden;
            border-right: 3px solid #0d6efd;
            display: inline-block;
            min-width: 10px; /* Prevents layout shift */
        }
        .auto-writing::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 0;
            height: 4px;
            background: #0d6efd; /* Blue highlighter */
            transition: width 0.05s linear;
        }
        .auto-writing.active::after {
            width: 100%;
        }
    </style>
</head>
<body>
    <!-- Hero Section -->
    <main class="col-12 main-content-lg-padding">
        <section class="hero-section text-center">
            <div class="container">
                <h1 class="auto-writing-container">
                    <span class="auto-writing" data-text="Welcome to ASSOTRACK"></span><br>
                    <span class="auto-writing" data-text="Association Management"></span><br><span class="auto-writing" data-text="Solution"></span>
                </h1>
                <p class="lead">Your centralized hub for managing Clubs, Associations, Groups, Societies, and more with transparency and ease.</p>
                <div class="cta-buttons">
                    <a href="login.php" class="btn btn-primary btn-lg me-2">Login to Your Account</a>
                    <a href="register.php" class="btn btn-secondary btn-lg">Join Our Club</a>
                </div>
            </div>
        </section>

        <!-- Features Section -->
        <section class="features-section">
            <div class="container">
                <h2 class="text-center mb-5">Explore Our Features</h2>
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-user-plus"></i>
                            <h4>Member Registration</h4>
                            <p>Easily register members and generate unique 5-digit membership IDs for clubs and associations.</p>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-image"></i>
                            <p>Members can upload profile pictures to personalize their accounts.</p>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-tachometer-alt"></i>
                            <h4>Member Dashboard</h4>
                            <p>Access a dedicated dashboard to view debts, announcements, send messages, pay dues, and track club financials.</p>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-user-shield"></i>
                            <h4>Admin Management</h4>
                            <p>Admins can manage memberships, approve/delete members, create payment types, and view detailed reports.</p>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-file-export"></i>
                            <h4>Reports & Exports</h4>
                            <p>Generate, print, and export financial reports to CSV with flexible database queries by name, ID, or time period.</p>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-headset"></i>
                            <h4>Live Support</h4>
                            <p>Access real-time support for members to resolve issues and get assistance instantly.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Why Choose Us Section -->
        <section class="why-choose-section">
            <div class="container">
                <h2 class="text-center mb-5">Why Use ASSOTRACK AMS?</h2>
                <div class="row">
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-users"></i>
                            <h4>Community Engagement</h4>
                            <p>Connect with like-minded individuals and participate in vibrant community activities and events.</p>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-shield-alt"></i>
                            <h4>Transparent Management</h4>
                            <p>Access a clear and organized portal for tracking payments, memberships, and announcements.</p>
                        </div>
                    </div>
                    <div class="col-md-4 mb-4">
                        <div class="feature-card text-center">
                            <i class="fas fa-hand-holding-heart"></i>
                            <h4>Member Benefits</h4>
                            <p>Enjoy exclusive benefits, rewards, and support tailored to our valued club members.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Call to Action Section -->
        <section class="call-to-action-section">
            <div class="container">
                <h2 class="mb-4">Get Started Today!</h2>
                <p class="lead mb-4">Join ASSOTRACK AMS or contact us for more information.</p>
                <div class="cta-buttons">
                    <a href="https://wa.me/2348165065763" target="_blank" class="btn btn-whatsapp btn-lg me-2">
                        <i class="fab fa-whatsapp me-2"></i> Chat on WhatsApp
                    </a>
                    <a href="contact.php" class="btn btn-primary btn-lg">
                        <i class="fas fa-envelope me-2"></i> Contact Us
                    </a>
                </div>
            </div>
        </section>
    </main>

    <!-- Footer -->
    <footer class="footer text-center">
        <div class="container">
            <p>&copy; <?php echo date('Y'); ?> MultiTask Club Management Solution. All rights reserved.</p>
            <div class="mt-2">
                <a href="privacy_policy.php" class="text-white me-3">Privacy Policy</a>
                <a href="terms_of_service.php" class="text-white">Terms of Service</a>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        const textElements = document.querySelectorAll('.auto-writing');

        function typeWriter(element, text, index, callback) {
            element.textContent = '';
            element.style.borderRight = '3px solid #0d6efd';
            let i = 0;

            function type() {
                if (i < text.length) {
                    element.textContent += text.charAt(i);
                    i++;
                    setTimeout(type, 50); // Adjust speed of typing (ms)
                } else {
                    element.classList.add('active'); // Trigger highlighter animation
                    element.style.borderRight = 'none'; // Remove cursor
                    setTimeout(() => {
                        element.classList.remove('active'); // Reset highlighter
                        callback(); // Proceed to next line or loop
                    }, 1000); // Delay before restarting
                }
            }

            type();
        }

        function animateLines(index = 0) {
            if (index >= textElements.length) {
                // Restart animation from the first line
                setTimeout(() => animateLines(0), 500);
                return;
            }

            const element = textElements[index];
            const text = element.getAttribute('data-text');
            typeWriter(element, text, 0, () => {
                // Move to the next line after current line animation completes
                animateLines(index + 1);
            });
        }

        // Start the animation
        animateLines();
    });
    </script>
</body>
</html>
<?php require_once 'includes/footer.php'; ?>