<?php
$tables = ['income', 'expenses', 'debts', 'benefits'];
require_once 'includes/header.php';
?>

<script>
// Set dynamic page title
document.title = 'Reports - <?php echo htmlspecialchars(get_setting('system_name', $link) ?? 'Club Portal'); ?>';
</script>

<style>
    .main-content { padding: 20px; }
    .table-responsive { max-height: 500px; overflow-y: auto; }
    .filter-section { background: #f8f9fa; padding: 15px; border-radius: 10px; }
    .filter-section .btn-reset { margin-top: 30px; }
    .table th, .table td { 
        white-space: nowrap; 
        overflow: hidden; 
        text-overflow: ellipsis; 
    }
    #incomeTable th:nth-child(1), #incomeTable td:nth-child(1) { width: 10%; }
    #incomeTable th:nth-child(2), #incomeTable td:nth-child(2) { width: 20%; }
    #incomeTable th:nth-child(3), #incomeTable td:nth-child(3) { width: 15%; }
    #incomeTable th:nth-child(4), #incomeTable td:nth-child(4) { width: 15%; }
    #incomeTable th:nth-child(5), #incomeTable td:nth-child(5) { width: 10%; }
    #incomeTable th:nth-child(6), #incomeTable td:nth-child(6) { width: 15%; }
    #incomeTable th:nth-child(7), #incomeTable td:nth-child(7) { width: 15%; }
    #incomeTable th:nth-child(8), #incomeTable td:nth-child(8) { width: 10%; }
    #incomeTable th:nth-child(9), #incomeTable td:nth-child(9) { width: 10%; }
    #expensesTable th:nth-child(1), #expensesTable td:nth-child(1) { width: 25%; }
    #expensesTable th:nth-child(2), #expensesTable td:nth-child(2) { width: 20%; }
    #expensesTable th:nth-child(3), #expensesTable td:nth-child(3) { width: 35%; }
    #expensesTable th:nth-child(4), #expensesTable td:nth-child(4) { width: 20%; }
    #benefitsTable th:nth-child(1), #benefitsTable td:nth-child(1) { width: 15%; }
    #benefitsTable th:nth-child(2), #benefitsTable td:nth-child(2) { width: 25%; }
    #benefitsTable th:nth-child(3), #benefitsTable td:nth-child(3) { width: 20%; }
    #benefitsTable th:nth-child(4), #benefitsTable td:nth-child(4) { width: 20%; }
    #benefitsTable th:nth-child(5), #benefitsTable td:nth-child(5) { width: 20%; }
    #debtsTable th:nth-child(1), #debtsTable td:nth-child(1) { width: 10%; }
    #debtsTable th:nth-child(2), #debtsTable td:nth-child(2) { width: 20%; }
    #debtsTable th:nth-child(3), #debtsTable td:nth-child(3) { width: 15%; }
    #debtsTable th:nth-child(4), #debtsTable td:nth-child(4) { width: 15%; }
    #debtsTable th:nth-child(5), #debtsTable td:nth-child(5) { width: 15%; }
    #debtsTable th:nth-child(6), #debtsTable td:nth-child(6) { width: 15%; }
    #debtsTable th:nth-child(7), #debtsTable td:nth-child(7) { width: 10%; }
    #debtsTable th:nth-child(8), #debtsTable td:nth-child(8) { width: 10%; }
    @media print {
        body * { visibility: hidden; }
        .print-card, .print-card * { visibility: visible; }
        .print-card { position: static; width: 100%; page-break-inside: avoid; }
        .no-print { display: none !important; }
        table { border-collapse: collapse; width: 100%; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        th { background-color: #f2f2f2; font-weight: bold; }
    }
</style>

<div class="container-fluid">
    <div class="row">
        <?php require_once 'includes/sidebar.php'; ?>
        <main class="col-md-9 col-lg-10 main-content">
            <h2>Reports</h2>
            <hr>

            <!-- Debug: Log payment_types_summary -->
            <?php error_log("reports_view.php: payment_types_summary=" . var_export($payment_types_summary, true)); ?>

            <!-- Filters Section -->
            <div class="mb-4 filter-section">
                <form method="GET" action="">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label for="recordTypeFilter" class="form-label">Record Type:</label>
                            <select id="recordTypeFilter" name="record_type" class="form-select">
                                <option value="all" <?php echo $record_type === 'all' ? 'selected' : ''; ?>>All</option>
                                <option value="income" <?php echo $record_type === 'income' ? 'selected' : ''; ?>>Income</option>
                                <option value="expenses" <?php echo $record_type === 'expenses' ? 'selected' : ''; ?>>Expenses</option>
                                <option value="debts" <?php echo $record_type === 'debts' ? 'selected' : ''; ?>>Debt</option>
                                <option value="benefits" <?php echo $record_type === 'benefits' ? 'selected' : ''; ?>>Benefits</option>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="startDate" class="form-label">Start Date:</label>
                            <input type="date" id="startDate" name="start_date" class="form-control" value="<?php echo htmlspecialchars($start_date); ?>">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="endDate" class="form-label">End Date:</label>
                            <input type="date" id="endDate" name="end_date" class="form-control" value="<?php echo htmlspecialchars($end_date); ?>">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="search" class="form-label">Search:</label>
                            <input type="text" id="search" name="search" class="form-control" value="<?php echo htmlspecialchars($search); ?>" placeholder="Search...">
                        </div>
                        <div class="col-md-3 mb-3">
                            <label for="typeFilter" class="form-label">Type Filter:</label>
                            <select id="typeFilter" name="type_filter" class="form-select">
                                <option value="">All Types</option>
                                <?php
                                $payment_types = get_all_payment_types($link);
                                foreach ($payment_types as $type) {
                                    echo "<option value='income_" . htmlspecialchars($type) . "' " . ($type_filter === 'income_' . $type ? 'selected' : '') . ">" . htmlspecialchars($type) . " (Income)</option>";
                                }
                                $expense_types = get_all_expense_types($link);
                                foreach ($expense_types as $type) {
                                    echo "<option value='expense_" . htmlspecialchars($type) . "' " . ($type_filter === 'expense_' . $type ? 'selected' : '') . ">" . htmlspecialchars($type) . " (Expense)</option>";
                                }
                                $benefit_types = get_all_benefit_types($link);
                                foreach ($benefit_types as $type) {
                                    echo "<option value='benefit_" . htmlspecialchars($type) . "' " . ($type_filter === 'benefit_' . $type ? 'selected' : '') . ">" . htmlspecialchars($type) . " (Benefit)</option>";
                                }
                                ?>
                            </select>
                        </div>
                        <div class="col-md-3 mb-3">
                            <button type="submit" class="btn btn-primary mt-4">Apply Filters</button>
                            <button type="button" class="btn btn-secondary btn-reset mt-4 ms-2" onclick="resetFilters()">Reset Filters</button>
                        </div>
                        <?php foreach ($tables as $table): ?>
                            <input type="hidden" name="page_<?php echo $table; ?>" value="<?php echo $pagination[$table]['page']; ?>">
                            <input type="hidden" name="per_page_<?php echo $table; ?>" value="<?php echo $pagination[$table]['per_page']; ?>">
                        <?php endforeach; ?>
                    </div>
                </form>
            </div>

            <!-- Financial Metrics -->
            <div class="card mb-4 print-card" id="financialMetricsCard">
                <div class="card-header">
                    <span>Financial Metrics</span>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <p><strong>Total Required:</strong> <?php echo format_currency($financial_metrics['total_required'] ?? 0.0, $currency_symbol); ?></p>
                        </div>
                        <div class="col-md-3">
                            <p><strong>Total Income:</strong> <?php echo format_currency($financial_metrics['total_income'] ?? 0.0, $currency_symbol); ?></p>
                        </div>
                        <div class="col-md-3">
                            <p><strong>Total Debt:</strong> <?php echo format_currency($financial_metrics['total_debt'] ?? 0.0, $currency_symbol); ?></p>
                        </div>
                        <div class="col-md-3">
                            <p><strong>Available Balance:</strong> <?php echo format_currency($financial_metrics['available_balance'] ?? 0.0, $currency_symbol); ?></p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Type Summaries -->
            <div class="card mb-4 print-card" id="typeSummariesCard">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Type Summaries</span>
                    <?php if ($is_admin): ?>
                        <div class="no-print">
                            <button class="btn btn-sm btn-outline-danger" onclick="exportPDF('type_summaries')"><i class="fas fa-file-pdf"></i> Export PDF</button>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="card-body">
                    <div class="row">
                        <?php foreach ([
                            'Payments' => ['data' => $payment_types_summary, 'columns' => ['Type', 'Required Amount', 'Total Paid', 'Total Debt'], 'permission' => 'view_payments'],
                            'Expenses' => ['data' => $expense_types_summary, 'columns' => ['Type', 'Total'], 'permission' => 'view_expenses'],
                            'Benefits' => ['data' => $benefit_types_summary, 'columns' => ['Type', 'Total'], 'permission' => 'view_benefits']
                        ] as $title => $info): ?>
                            <?php if ($record_type === 'all' || $record_type === strtolower($title)): ?>
                                <?php if (user_has_permission($link, $info['permission'])): ?>
                                    <div class="col-md-4 mb-3">
                                        <h5><?php echo htmlspecialchars($title); ?> Summary</h5>
                                        <div class="table-responsive print-card">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <?php foreach ($info['columns'] as $column): ?>
                                                            <th><?php echo htmlspecialchars($column); ?></th>
                                                        <?php endforeach; ?>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php if (empty($info['data']) || !is_array($info['data'])): ?>
                                                        <tr><td colspan="<?php echo count($info['columns']); ?>" class="text-center">No data available.</td></tr>
                                                    <?php else: ?>
                                                        <?php foreach ($info['data'] as $row): ?>
                                                            <tr>
                                                                <td><?php echo htmlspecialchars($row['type_name'] ?? 'N/A'); ?></td>
                                                                <?php if ($title === 'Payments'): ?>
                                                                    <td><?php echo format_currency($row['required_amount'] ?? 0.0, $currency_symbol); ?></td>
                                                                    <td><?php echo format_currency($row['total_paid'] ?? 0.0, $currency_symbol); ?></td>
                                                                    <td><?php echo format_currency($row['total_debt'] ?? 0.0, $currency_symbol); ?></td>
                                                                <?php else: ?>
                                                                    <td><?php echo format_currency($row['total'] ?? 0.0, $currency_symbol); ?></td>
                                                                <?php endif; ?>
                                                            </tr>
                                                        <?php endforeach; ?>
                                                    <?php endif; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                <?php else: ?>
                                    <div class="col-md-4 mb-3">
                                        <h5><?php echo htmlspecialchars($title); ?> Summary</h5>
                                        <p class="text-danger">You do not have permission to view <?php echo htmlspecialchars($title); ?> data.</p>
                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

            <!-- Report Sections -->
            <?php foreach ([
                'income' => ['title' => 'Income Report', 'columns' => ['Member ID', 'Member Name', 'Payment Type', 'Amount', 'Status', 'Date', 'Payment Date', 'Payment Cycle', 'Event Date'], 'data' => $income, 'permission' => 'view_payments'],
                'expenses' => ['title' => 'Expenses Report', 'columns' => ['Type', 'Amount', 'Description', 'Date'], 'data' => $expenses, 'permission' => 'view_expenses'],
                'benefits' => ['title' => 'Benefits Report', 'columns' => ['Member ID', 'Member Name', 'Benefit Type', 'Amount', 'Date'], 'data' => $benefits, 'permission' => 'view_benefits'],
                'debts' => ['title' => 'Debt Report', 'columns' => ['Member ID', 'Member Name', 'Payment Type', 'Required Amount', 'Total Paid', 'Debt', 'Payment Cycle', 'Due Date'], 'data' => $debts, 'permission' => 'view_debts']
            ] as $table => $info): ?>
                <?php if ($record_type === 'all' || $record_type === $table): ?>
                <?php if (user_has_permission($link, $info['permission'])): ?>
                    <div class="card mb-4 print-card" id="<?php echo $table; ?>Card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <span><?php echo $info['title']; ?></span>
                            <?php if ($is_admin): ?>
                                <div class="no-print">
                                    <button class="btn btn-sm btn-outline-danger" onclick="exportPDF('<?php echo $table; ?>')"><i class="fas fa-file-pdf"></i> Export PDF</button>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">
                            <div class="mb-3 no-print">
                                <label for="recordsPerPage<?php echo ucfirst($table); ?>" class="form-label">Records per page:</label>
                                <select id="recordsPerPage<?php echo ucfirst($table); ?>" class="form-select w-auto d-inline-block" onchange="changeRecordsPerPage(this, '<?php echo $table; ?>')">
                                    <?php foreach ([5, 10, 25, 50, 100] as $num): ?>
                                        <option value="<?php echo $num; ?>" <?php echo $pagination[$table]['per_page'] == $num ? 'selected' : ''; ?>><?php echo $num; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover" id="<?php echo $table; ?>Table">
                                    <thead>
                                        <tr>
                                            <?php foreach ($info['columns'] as $col): ?>
                                                <th><?php echo htmlspecialchars($col); ?></th>
                                            <?php endforeach; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if (empty($info['data'])): ?>
                                            <tr><td colspan="<?php echo count($info['columns']); ?>" class="text-center">No <?php echo strtolower($info['title']); ?> found.</td></tr>
                                        <?php else: ?>
                                            <?php foreach ($info['data'] as $record): ?>
                                                <tr>
                                                    <?php if ($table === 'income'): ?>
                                                        <td><?php echo htmlspecialchars($record['member_id'] ?? 'N/A'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['full_name'] ?? 'Unknown'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['payment_type'] ?? 'N/A'); ?></td>
                                                        <td><?php echo format_currency($record['amount'] ?? 0, $currency_symbol); ?></td>
                                                        <td><span class="badge bg-<?php echo ($record['payment_status'] === 'Paid') ? 'success' : 'danger'; ?>">
                                                            <?php echo htmlspecialchars($record['payment_status'] ?? 'N/A'); ?>
                                                        </span></td>
                                                        <td><?php echo htmlspecialchars($record['created_at'] ? date('Y-m-d', strtotime($record['created_at'])) : 'N/A'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['payment_date'] ? date('Y-m-d', strtotime($record['payment_date'])) : 'N/A'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['payment_cycle'] ?? 'N/A'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['event_date'] ?? 'N/A'); ?></td>
                                                    <?php elseif ($table === 'expenses'): ?>
                                                        <td><?php echo htmlspecialchars($record['expense_type'] ?? 'N/A'); ?></td>
                                                        <td><?php echo format_currency($record['amount'] ?? 0, $currency_symbol); ?></td>
                                                        <td><?php echo htmlspecialchars(truncate_text($record['description'] ?? 'N/A', 50)); ?></td>
                                                        <td><?php echo htmlspecialchars($record['created_at'] ? date('Y-m-d', strtotime($record['created_at'])) : 'N/A'); ?></td>
                                                    <?php elseif ($table === 'benefits'): ?>
                                                        <td><?php echo htmlspecialchars($record['member_id'] ?? 'N/A'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['full_name'] ?? 'Unknown'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['benefit_type'] ?? 'N/A'); ?></td>
                                                        <td><?php echo format_currency($record['amount'] ?? 0, $currency_symbol); ?></td>
                                                        <td><?php echo htmlspecialchars($record['created_at'] ? date('Y-m-d', strtotime($record['created_at'])) : 'N/A'); ?></td>
                                                    <?php elseif ($table === 'debts'): ?>
                                                        <td><?php echo htmlspecialchars($record['member_id'] ?? 'N/A'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['full_name'] ?? 'Unknown'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['payment_type'] ?? 'N/A'); ?></td>
                                                        <td><?php echo format_currency($record['required_amount'] ?? 0, $currency_symbol); ?></td>
                                                        <td><?php echo format_currency($record['total_paid'] ?? 0, $currency_symbol); ?></td>
                                                        <td><?php echo format_currency($record['debt'] ?? 0, $currency_symbol); ?></td>
                                                        <td><?php echo htmlspecialchars($record['payment_cycle'] ?? 'N/A'); ?></td>
                                                        <td><?php echo htmlspecialchars($record['due_date'] ? date('Y-m-d', strtotime($record['due_date'])) : 'N/A'); ?></td>
                                                    <?php endif; ?>
                                                </tr>
                                            <?php endforeach; ?>
                                        <?php endif; ?>
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <td colspan="<?php echo count($info['columns']) - 1; ?>" class="text-end"><strong>Total:</strong></td>
                                            <td><strong><?php echo format_currency(array_sum(array_column($info['data'], $table === 'debts' ? 'debt' : 'amount')), $currency_symbol); ?></strong></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                            <div class="no-print">
                                <nav aria-label="Pagination for <?php echo $table; ?>">
                                    <ul class="pagination justify-content-center">
                                        <?php if ($total_pages[$table] > 1): ?>
                                            <li class="page-item <?php echo $pagination[$table]['page'] <= 1 ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?record_type=<?php echo urlencode($record_type); ?>&start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&search=<?php echo urlencode($search); ?>&type_filter=<?php echo urlencode($type_filter); ?>&page_<?php echo $table; ?>=<?php echo $pagination[$table]['page'] - 1; ?>&per_page_<?php echo $table; ?>=<?php echo $pagination[$table]['per_page']; ?><?php foreach ($tables as $t) { if ($t !== $table) echo "&page_$t=" . urlencode($pagination[$t]['page']) . "&per_page_$t=" . urlencode($pagination[$t]['per_page']); } ?>" aria-label="Previous">
                                                    <span aria-hidden="true">&laquo;</span>
                                                </a>
                                            </li>
                                            <?php for ($i = 1; $i <= $total_pages[$table]; $i++): ?>
                                                <li class="page-item <?php echo $pagination[$table]['page'] == $i ? 'active' : ''; ?>">
                                                    <a class="page-link" href="?record_type=<?php echo urlencode($record_type); ?>&start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&search=<?php echo urlencode($search); ?>&type_filter=<?php echo urlencode($type_filter); ?>&page_<?php echo $table; ?>=<?php echo $i; ?>&per_page_<?php echo $table; ?>=<?php echo $pagination[$table]['per_page']; ?><?php foreach ($tables as $t) { if ($t !== $table) echo "&page_$t=" . urlencode($pagination[$t]['page']) . "&per_page_$t=" . urlencode($pagination[$t]['per_page']); } ?>"><?php echo $i; ?></a>
                                                </li>
                                            <?php endfor; ?>
                                            <li class="page-item <?php echo $pagination[$table]['page'] >= $total_pages[$table] ? 'disabled' : ''; ?>">
                                                <a class="page-link" href="?record_type=<?php echo urlencode($record_type); ?>&start_date=<?php echo urlencode($start_date); ?>&end_date=<?php echo urlencode($end_date); ?>&search=<?php echo urlencode($search); ?>&type_filter=<?php echo urlencode($type_filter); ?>&page_<?php echo $table; ?>=<?php echo $pagination[$table]['page'] + 1; ?>&per_page_<?php echo $table; ?>=<?php echo $pagination[$table]['per_page']; ?><?php foreach ($tables as $t) { if ($t !== $table) echo "&page_$t=" . urlencode($pagination[$t]['page']) . "&per_page_$t=" . urlencode($pagination[$t]['per_page']); } ?>" aria-label="Next">
                                                    <span aria-hidden="true">&raquo;</span>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="card mb-4 print-card" id="<?php echo $table; ?>Card">
                        <div class="card-header">
                            <span><?php echo $info['title']; ?></span>
                        </div>
                        <div class="card-body">
                            <p class="text-danger">You do not have permission to view <?php echo htmlspecialchars($info['title']); ?> data.</p>
                        </div>
                    </div>
                <?php endif; ?>
                <?php endif; ?>
            <?php endforeach; ?>
        </main>
    </div>
</div>

<script>
function exportPDF(table) {
    const params = new URLSearchParams(window.location.search);
    params.set('export_pdf', table);
    window.location.href = '?' + params.toString();
}

function changeRecordsPerPage(select, table) {
    const params = new URLSearchParams(window.location.search);
    params.set('per_page_' + table, select.value);
    params.set('page_' + table, '1');
    window.location.href = '?' + params.toString();
}

function resetFilters() {
    window.location.href = 'reports.php';
}
</script>

<?php require_once 'includes/footer.php'; ?>