<?php
function sanitize_filter($input, $valid_options, $default) {
    return in_array($input, $valid_options) ? $input : $default;
}

function validate_type_filter($type_filter, $record_type) {
    if ($type_filter === '') {
        return '';
    }
    $type_parts = explode('_', $type_filter, 2);
    $type_category = $type_parts[0] ?? '';
    $type_name = $type_parts[1] ?? '';
    if ($type_category && $type_name && in_array($type_category, ['income', 'expense', 'benefit'])) {
        if ($record_type === 'all' || $record_type === ($type_category === 'income' ? 'income' : $type_category . 's')) {
            if ($type_category === 'income') {
                return " AND po.payment_type = ?";
            } elseif ($type_category === 'expense') {
                return " AND et.type_name = ?";
            } elseif ($type_category === 'benefit') {
                return " AND bt.type_name = ?";
            }
        }
    }
    error_log("Invalid type_filter format: $type_filter");
    return '';
}

function build_time_filter($time_period, $date_field, $record_type) {
    if ($time_period === 'all') {
        return '';
    }
    $date_column = ($date_field === 'due_date' && $record_type === 'debts') ? 'po.due_date' : 'created_at';
    switch ($time_period) {
        case 'date':
            return " AND DATE($date_column) = ?";
        case 'week':
            return " AND $date_column >= DATE_SUB(CURDATE(), INTERVAL 1 WEEK)";
        case 'month':
            return " AND $date_column >= DATE_SUB(CURDATE(), INTERVAL 1 MONTH)";
        case 'year':
            return " AND $date_column >= DATE_SUB(CURDATE(), INTERVAL 1 YEAR)";
        default:
            return '';
    }
}
?>