<?php
require_once 'includes/functions.php';
require_once 'includes/db_config.php';

// Check if user is logged in and is an admin
if (!is_logged_in() || !is_admin()) {
    redirect("login.php");
}

if (isset($_GET['id']) && !empty($_GET['id'])) {
    $payment_id = intval($_GET['id']);

    // Use a prepared statement to prevent SQL injection
    $sql = "DELETE FROM payments WHERE id = ?";
    if ($stmt = mysqli_prepare($link, $sql)) {
        mysqli_stmt_bind_param($stmt, "i", $payment_id);
        if (mysqli_stmt_execute($stmt)) {
            // Success
            redirect("payment_management.php?message=Payment deleted successfully.");
        } else {
            // Error
            redirect("payment_management.php?error=Error deleting payment.");
        }
        mysqli_stmt_close($stmt);
    } else {
        redirect("payment_management.php?error=Database error.");
    }
} else {
    redirect("payment_management.php?error=Invalid request.");
}
?>